<?php
namespace lexicon\system\application\worker;

use lexicon\system\parser\MessageParser;
use wbb\data\post\PostAction;
use wbb\data\post\PostList;

/**
 * execute changes in WoltLab Burning Board
 *
 * @author	Peter Fruehwirt
 * @copyright	2009-2013 VieCode
 * @license	VieCode Commercial License <http://www.viecode.com/licence/commercial/>
 * @package	com.viecode.lexicon.worker
 * @category	Lexicon Worker
 * @subpackage	system.application.worker
 */
class BurningBoardApplicationWorker implements IApplicationWorker {

	/**
	 * parser object
	 * @var \lexicon\system\parser\MessageParser
	 */
	private $parser;

	/**
	 * constructor
	 */
	public function __construct() {
		$this->parser = new MessageParser();
	}

	/**
	 * @see	\lexicon\system\application\worker\IApplicationWorker::getObjectCount()
	 */
	public function getObjectCount() {
		$objectList = new PostList();
		return $objectList->countObjects();
	}

	/**
	 * @see	\lexicon\system\application\worker\IApplicationWorker::execute()
	 */
	public function execute($offset, $limit) {
		$objectList = new PostList();
		$objectList->sqlOrderBy = 'post.postID ASC';
		$objectList->sqlOffset = $offset;
		$objectList->sqlLimit = $limit;

		$objectList->readObjects();
		foreach ($objectList->getObjects() as $object) {
			$action = new PostAction(array($object), 'update', array(
				'data' => array(
					'message' => $this->parser->parse($object->message)
				)
			));
			$action->executeAction();
		}
	}
}
