<?php
namespace lexicon\system\application\worker;

use filebase\data\entry\EntryAction;
use filebase\data\entry\EntryList;
use lexicon\system\parser\MessageParser;

/**
 * execute changes in VieCode webdisk
 *
 * @author	Peter Fruehwirt
 * @copyright	2009-2013 VieCode
 * @license	VieCode Commercial License <http://www.viecode.com/licence/commercial/>
 * @package	com.viecode.lexicon.worker
 * @category	Lexicon Worker
 * @subpackage	system.application.worker
 */
class WebdiskApplicationWorker implements IApplicationWorker {

	/**
	 * parser object
	 * @var \lexicon\system\parser\MessageParser
	 */
	private $parser;

	/**
	 * constructor
	 */
	public function __construct() {
		$this->parser = new MessageParser();
	}

	/**
	 * @see	\lexicon\system\application\worker\IApplicationWorker::getObjectCount()
	 */
	public function getObjectCount() {
		$objectList = new EntryList();
		return $objectList->countObjects();
	}

	/**
	 * @see	\lexicon\system\application\worker\IApplicationWorker::execute()
	 */
	public function execute($offset, $limit) {
		$objectList = new EntryList();
		$objectList->sqlOrderBy = 'entry.entryID ASC';
		$objectList->sqlOffset = $offset;
		$objectList->sqlLimit = $limit;

		$objectList->readObjects();
		foreach ($objectList->getObjects() as $object) {
			$action = new EntryAction(array($object), 'update', array(
				'data' => array(
					'subject' => $object->subject,
					'message' => $this->parser->parse($object->message),
					'isPrivate' => $object->isPrivate
				)
			));
			$action->executeAction();
		}
	}
}
