<?php
namespace lexicon\acp\page;
use wcf\data\object\type\ObjectTypeCache;
use wcf\data\package\Package;
use wcf\data\package\PackageCache;
use wcf\page\AbstractPage;
use wcf\system\WCF;

/**
 * Shows available application worker
 *
 * @author	Peter Fruehwirt
 * @copyright	2009-2013 VieCode
 * @license	VieCode Commercial License <http://www.viecode.com/licence/commercial/>
 * @package	com.viecode.lexicon.worker
 * @category	Lexicon Worker
 * @subpackage	acp.page
 */
class WorkerPage extends AbstractPage {
	/**
	 * @see	\wcf\page\AbstractPage::$activeMenuItem
	 */
	public $activeMenuItem = 'lexicon.acp.menu.link.lexicon.worker';

	/**
	 * @see	\wcf\page\AbstractPage::$neededPermissions
	 */
	public $neededPermissions = array('admin.lexicon.canRunWorker');

	/**
	 * supported packages
	 * @var array
	 */
	public $supportedPackages = array();

	/**
	 * @see wcf\page\AbstractPage::readData
	 */
	public function readData() {
		parent::readData();

		foreach (ObjectTypeCache::getInstance()->getObjectTypes('com.viecode.lexicon.worker.application') as $objectType) {
			$package = PackageCache::getInstance()->getPackageByIdentifier($objectType->package);
			if ($package == null) continue;
			if ($objectType->minVersion != null && Package::compareVersion($package->packageVersion, $objectType->minVersion, '<')) continue;
			if ($objectType->maxVersion != null && Package::compareVersion($package->packageVersion, $objectType->maxVersion, '>')) continue;

			$this->supportedPackages[] = $package;
		}
	}

	public function assignVariables() {
		parent::assignVariables();

		WCF::getTPL()->assign(array(
			'supportedPackages' => $this->supportedPackages
		));
	}
}
