{include file='header' pageTitle='lexicon.acp.worker.list'}


<script data-relocate="true">
	//<![CDATA[
	$(function() {
		WCF.Language.addObject({
			'lexicon.acp.worker.run.confirm': '{lang}lexicon.acp.worker.run.confirm{/lang}',
			'wcf.acp.worker.abort.confirmMessage': '{lang}wcf.acp.worker.abort.confirmMessage{/lang}'
		});
	});
	//]]>
</script>

<header class="boxHeadline">
	<h1>{lang}lexicon.acp.worker.list{/lang}</h1>

</header>



{if $supportedPackages|count}
	<p class="info">{lang}lexicon.acp.worker.description{/lang}</p>

	<div class="container containerPadding marginTop">

		<fieldset>
			<legend>{lang}lexicon.acp.worker.supportedPackages{/lang}</legend>

			<ul>
				{foreach from=$supportedPackages item=$package}
				<li class="box16">
					<span class="icon icon162 icon-ok"></span>

					<div>
						<strong>{$package->packageName|language} {$package->packageVersion}</strong> ({$package->package})
					</div>
				</li>
				{/foreach}
			</ul>
		</fieldset>

		<div class="formSubmit">
			<input id="run" type="button" value="{lang}lexicon.acp.worker.run{/lang}" accesskey="s" />


			<script data-relocate="true">
				//<![CDATA[
				$(function() {
					$('#run').click(function () {
						new WCF.ACP.Worker('cache', 'lexicon\\system\\worker\\RebuildApplicationObjectWorker', '{lang}lexicon.acp.worker.list{/lang}');
					});
				});
				//]]>
			</script>
		</div>
	</div>
{else}
	<p class="info">{lang}wcf.global.noItems{/lang}</p>
{/if}

{include file='footer'}
