<?php
require_once(WCF_DIR.'lib/data/database/importer/AbstractDatabaseExporter.class.php');

/**
 * 
 * @author 	Markus Gerdelmann
 * @copyright	2005-2011 MDMAN <> viecode.com
 * @package	de.wbb-security.database.importer
 */
class WComDatabase12xExporter extends AbstractDatabaseExporter {
	
	/**
	 * @see AbstractDatabaseExporter::$useDatabase
	 */
	public $useDatabase = true;
	
	/**
	 * @see AbstractDatabaseExporter::$supportedDatabaseClasses
	 */
	public $supportedDatabaseClasses = array('MySQLDatabase');
	
	/**
	 * @see AbstractDatabaseExporter::$supportedData;
	 */
	public $supportedData = array(
		'categories' => 1, 
		'items' => 1, 
		'files' => 1, 
		'links' => 1, 
		'optionals' => 0, 
		'thumbnails' => 1,
		'activation' => 1
	);
	
	/**
	 * @see AbstractDatabaseExporter::$settings
	 */
	public $settings = array(
		'encoding' => 'ISO-8859-1',
		'boardID' => 0,
		'dbClass' => '',
		'dbHost' => 'localhost',
		'dbUser' => '',
		'dbPassword' => '',
		'dbName' => '',
		'dbNumber' => 1,
		'sourcePath' => WCF_DIR
	);
	
	/**
	 * @see AbstractDatabaseExporter::validate()
	 */
	public function validate() {
		parent::validate();
		
		// db number
		$this->settings['dbNumber'] = intval($this->settings['dbNumber']);
		// search a wcf table
		try {
			$this->getDB()->sendQuery("SELECT COUNT(*) FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_package");
		}
		catch (Exception $e) {
			throw new UserInputException('dbNumber', 'invalid');
		}
		
		// search database table
		try {
			$this->getDB()->sendQuery("SELECT COUNT(*) FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data");
		}
		catch (Exception $e) {
			throw new UserInputException('dbNumber', 'noDownloadDatabase');
		}

		// source path
		$tmpPath = FileUtil::addTrailingSlash($this->settings['sourcePath']);
		if ($this->data['files'] || $this->data['thumbnails']) {
			if (!@file_exists($tmpPath.'lib/core.functions.php')) {
				$tmpPath = FileUtil::addTrailingSlash(dirname($tmpPath));
				if (!@file_exists($tmpPath.'lib/core.functions.php')) {
					throw new UserInputException('sourcePath', 'invalid');
				}
			}
		}
		
		$this->settings['sourcePath'] = $tmpPath;
	}
	
	/**
	 * @see AbstractDatabaseExporter::countCategories();
	 */
	public function countCategories() {
		$row = $this->getDB()->getFirstRow("SELECT COUNT(categoryID) AS `count` FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_categories");
		return $row['count'];
	}
	
	/**
	 * @see AbstractDatabaseExporter::countItems();
	 */
	public function countItems() {
		$row = $this->getDB()->getFirstRow("SELECT COUNT(dataID) AS `count` FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data");
		return $row['count'];
	}
	
	/**
	 * @see AbstractDatabaseExporter::countThumbnails();
	 */
	public function countThumbnails() {
		$row = $this->getDB()->getFirstRow("SELECT COUNT(dataID) AS `count` FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data WHERE previewIMG != ''");
		return $row['count'];
	}
	
	/**
	 * @see AbstractDatabaseExporter::countFiles();
	 */
	public function countFiles() {
		$row = $this->getDB()->getFirstRow("SELECT COUNT(dataID) AS `count` FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data WHERE fileName != ''");
		return $row['count'];
	}
	
	/**
	 * @see AbstractDatabaseExporter::countLinks();
	 */
	public function countLinks() {
		$row = $this->getDB()->getFirstRow("SELECT COUNT(dataID) AS `count` FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data WHERE fileName = ''");
		return $row['count'];
	}

	/**
	 * @see AbstractDatabaseExporter::countOptionals();
	 */
	public function countOptionals() {
		return 0;
	}
	
	/**
	 * @see AbstractDatabaseExporter::Activation();
	 */
	public function countActivation() {
		return $this->countItems();
	}
	

	/**
	 * @see AbstractDatabaseExporter::exportCategories();
	 */
	public function exportCategories($offset,$limit) {
		$result = $this->getDB()->sendQuery("SELECT * FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_categories",$limit,$offset);
		while($row = $this->getDB()->fetchArray($result)) {
			$this->getImporter()->importCategory("c".$row['categoryID'],$row['name'],$row['description'],"c".$row['topID'],$row['sortOrder'],1,"",0);
		}
	}
	
	/**
	 * @see AbstractDatabaseExporter::exportItems();
	 */
	public function exportItems($offset,$limit) {
		
		$users = array();
		$result = WCF::getDB()->sendQuery("SELECT userID, username FROM wcf".WCF_N."_user");
		while($row = WCF::getDB()->fetchArray($result)) {
			$users[$row['userID']] = $row['username'];
		}
		
		$result = $this->getDB()->sendQuery("SELECT d.*,u.username FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data AS `d` LEFT JOIN ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_user AS `u` ON (u.userID = d.userID)",$limit,$offset);
		while($row = $this->getDB()->fetchArray($result)) {
			
			if(!isset($users[$row['userID']]) OR $users[$row['userID']] != $row['username']) {
				$row['userID'] = 0;
			}
			
			$this->getImporter()->importItem("i".$row['dataID'],$row['name'],"c".$row['categoryID'],"","",$row['description'],$row['enableSmilies'],$row['enableHtml'],$row['enableBBCodes'],$row['username'],$row['userID']);
		}
	}
	
	/**
	 * @see AbstractDatabaseExporter::exportThumbnails();
	 */
	public function exportThumbnails($offset,$limit) {
		$result = $this->getDB()->sendQuery("SELECT * FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data WHERE previewIMG != ''",$limit,$offset);
		while($row = $this->getDB()->fetchArray($result)) {
			$this->getImporter()->importThumbnail("t".$row['dataID'],"i".$row['dataID'],$this->settings['sourcePath'].$row['previewIMG'],"",$row['userID']);
		}
	}
	
	/**
	 * @see AbstractDatabaseExporter::exportFiles();
	 */
	public function exportFiles($offset,$limit) {
		$result = $this->getDB()->sendQuery("SELECT * FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data WHERE fileName != ''",$limit,$offset);
		while($row = $this->getDB()->fetchArray($result)) {
			$this->getImporter()->importFile("f".$row['dataID'],"i".$row['dataID'],$this->settings['sourcePath']."downloads/Upload-".$row['dataID'].".".$row['fileExtension'],$row['fileName'],$row['mimeType'],$row['userID']);
		}
	}
	
	/**
	 * @see AbstractDatabaseExporter::exportLinks();
	 */
	public function exportLinks($offset,$limit) {
		$result = $this->getDB()->sendQuery("SELECT * FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data WHERE fileName = ''",$limit,$offset);
		while($row = $this->getDB()->fetchArray($result)) {
			$this->getImporter()->importLinks("l".$row['dataID'],"i".$row['dataID'],$row['link'],$row['userID']);
		}
	}
	
	/**
	 * @see AbstractDatabaseExporter::exportOptionals();
	 */
	public function exportOptionals($offset,$limit) {
		//nothing
	}
	
	/**
	 * @see AbstractDatabaseExporter::exportActivation();
	 */
	public function exportActivation($offset,$limit) {
		$result = $this->getDB()->sendQuery("SELECT dataID FROM ".$this->dbPrefix."wcf".$this->settings['dbNumber']."_dldb_data",$limit,$offset);
		while($row = $this->getDB()->fetchArray($result)) {
			$this->getImporter()->activateItem("i".$row['dataID']);
		}
	}
	
}
?>