<?php
require_once(WCF_DIR.'lib/data/DatabaseObject.class.php');

/**
 * Represents an userpic, modified userpic (c) WoltLab GmbH
 * 
 * @author	Peter Frhwirt
 * @package	de.wbb-security.profile.userpic
 */
class Userpic extends DatabaseObject {
	/**
	 * Creates a new userpic object.
	 * 
	 * @param	array		$row
	 * @param	integer		$userpicID
	 */
	public function __construct($userpicID, $row = null) {
		if ($userpicID !== null) {
			$sql = "SELECT	*
				FROM	wcf".WCF_N."_user_pictures
				WHERE	userpicID = ".$userpicID;
			$row = WCF::getDB()->getFirstRow($sql);
		}
		
		parent::__construct($row);
	}
	
	/**
	 * Returns the url to this userpic.
	 * 
	 * @return	string
	 */
	public function getURL() {
		return RELATIVE_WCF_DIR . 'images/userpics/userpic-' . $this->userpicID . '.' . StringUtil::encodeHTML($this->userpicExtension);
	}
	
	/**
	 * Returns the url of the user pic (needed for the gray box)
	 *
	 * @return 	string
	 */
	public function getStyleURL() {
		return '../userpic-' . $this->userpicID . '.' . StringUtil::encodeHTML($this->userpicExtension);
	}
		
	
	/**
	 * Returns the url to this userpic preview.
	 * 
	 * @return	string
	 */
	public function getPreviewURL() {
		return RELATIVE_WCF_DIR . 'images/userpics/userpic.preview-' . $this->userpicID . '.' . StringUtil::encodeHTML($this->userpicExtension);
	}
	
	/**
	 * Returns the html code to display this userpic.
	 * 
	 * @return	string
	 */
	public function __toString() {
		return '<img src="'.$this->getURL().'" style="width: '.$this->width.'px; height: '.$this->height.'px; border: 0px;" alt="" />';
	}
	
	/**
	 * Returns the html code to display this userpic preview.
	 * 
	 * @return	string
	 */
	public function getPreview() {
		//return '<a href="javascript:openPictureWindow('.$this->userID.','.$this->width.','.$this->height.');"><img src="'.$this->getPreviewURL().'" style="width: '.$this->thumbnailWidth.'px; height: '.$this->thumbnailHeight.'px" alt="" /></a>';
		
		return "<a href=\"#\" onclick=\"return GB_showImageSet([{'caption': '".addslashes(WCF::getLanguage()->get('wcf.user.profile.userpic'))."', 'url': '".$this->getStyleURL()."'}], 1)\"><img src=\"".$this->getPreviewURL()."\" style=\"width: ".$this->thumbnailWidth."px; height: ".$this->thumbnailHeight."px\" alt=\"\" /></a>";
	}
	
	/**
	 * Scales the userpic to a specific maximum height.
	 * 
	 * @param	integer		$maxHeight
	 */
	public function setMaxHeight($maxHeight) {
		if ($this->height > $maxHeight) {
			$this->data['width'] = round($this->width * $maxHeight / $this->height, 0);
			$this->data['height'] = $maxHeight;
			return true;
		}
		
		return false;
	}
	
	/**
	 * Scales the userpic to a specific maximum size.
	 * 
	 * @param	integer		$maxHeight
	 */
	public function setMaxSize($maxWidth, $maxHeight) {
		if ($this->width > $maxWidth || $this->height > $maxHeight) {
			$widthFactor = $maxWidth / $this->width;
			$heightFactor = $maxHeight / $this->height;
			
			if ($widthFactor < $heightFactor) {
				$this->data['width'] = $maxWidth;
				$this->data['height'] = round($this->height * $widthFactor, 0);
			}
			else {
				$this->data['width'] = round($this->width * $heightFactor, 0);
				$this->data['height'] = $maxHeight;
			}
			
			return true;
		}
		
		return false;
	}
}
?>