{include file="documentHeader"}
<head>
	<title>{lang}wcf.user.userpic{/lang} - {lang}wcf.user.usercp{/lang} - {PAGE_TITLE}</title>
	<link rel="stylesheet" type="text/css" media="screen" href="{@RELATIVE_WCF_DIR}style/userpic.css" />
	
	{include file='headInclude' sandbox=false}
	<script type="text/javascript">
		//<![CDATA[
		function checkUserpicUploadInput() {
			if (document.getElementById('userpicUpload').value == '') {
				enableOptions('userpicURL');
			}
			if (document.getElementById('userpicURL').value == '' || document.getElementById('userpicURL').value == 'http://') {
				enableOptions('userpicUpload');
			}
			
			if (document.getElementById('userpicUpload').value != '' && (document.getElementById('userpicURL').value == '' || document.getElementById('userpicURL').value == 'http://')) {
				disableOptions('userpicURL');
			}
			if (document.getElementById('userpicUpload').value == '' && document.getElementById('userpicURL').value != '' && document.getElementById('userpicURL').value != 'http://') {
				disableOptions('userpicUpload');
			}
		}
		
		function disableUpload() {
			{if $disableUserpic != 1}
				//document.getElementById('userpicPreview').innerHTML = '<img src="{@RELATIVE_WCF_DIR}images/userpics/userpic-default.png" style="width: 200px; height: 150px; margin-left: -100px; margin-top: -75px;" alt="" />';
			{/if}
			disableOptions('userpicUpload', 'userpicURL');
		}
		
		function enableUpload() {
			{if $disableUserpic != 1}
				{if $currentUserpic}
					//document.getElementById('userpicPreview').innerHTML = '<img src="{$currentUserpic->getURL()}" alt="" style="width: {@$currentUserpic->width}px; height: {@$currentUserpic->height}px; margin-top: -{@$currentUserpic->height/2|intval}px; margin-left: -{@$currentUserpic->width/2|intval}px">';
				{else}
					//document.getElementById('userpicPreview').innerHTML = '<img src="{@RELATIVE_WCF_DIR}images/userpics/userpic-default.png" style="width: 200px; height: 150px; margin-left: -100px; margin-top: -75px;" alt="" />';
				{/if}
			{/if}
			enableOptions('userpicUpload', 'userpicURL');
			checkUserpicUploadInput();
		}
		
		{if $userpicID == -1}
			onloadEvents.push(function() { checkUserpicUploadInput(); });
		{else}
			onloadEvents.push(function() { disableOptions('userpicUpload', 'userpicURL'); });
		{/if}
		//]]>
	</script>

</head>
<body>
{include file='header' sandbox=false}

<div id="main">
	
	{capture append=userMessages}
		{if $errorField}
			<p class="error">{lang}wcf.global.form.error{/lang}</p>
		{/if}
		
		{if $disableUserpic}
			<p class="error">{lang}wcf.user.userpic.error.disabled{/lang}</p>
		{/if}
		
		{if $success|isset}
			<p class="success">{lang}wcf.user.userpic.success{/lang}</p>
		{/if}
	{/capture}
	
	{include file="userCPHeader"}
	
	<form method="post" enctype="multipart/form-data" action="index.php?form=UserpicEdit">
		<div class="border tabMenuContent">
		
			<div class="container-1">
				
				<h3 class="subHeadline"><!-- <img src="{@RELATIVE_WCF_DIR}icon/userpicM.png" alt="" /> -->{lang}wcf.user.userpic{/lang}</h3>
				<input type="hidden" name="userpicID" value="{@$userpicID}" />
				
				<div class="userpicNone">
					<label><input onclick="if (IS_SAFARI) disableUpload()" onfocus="disableUpload()" type="radio" name="userpicID" value="0"{if $userpicID == 0} checked="checked"{/if} /> {lang}wcf.user.userpic.disable{/lang}</label>
				</div>
				
				<div class="userpicSelection">
				
					<div class="userpicDisplay" style="width: 210px;">
						<fieldset style="width: 200px;">
							<legend>{lang}wcf.user.userpic.currentUserpic{/lang}</legend>
							<div id="userpicPreview" class="border">
								{if $currentUserpic}
									<img src="{$currentUserpic->getPreviewURL()}" alt="" style="width: {@$currentUserpic->thumbnailWidth}px; height: {@$currentUserpic->thumbnailHeight}px; margin-top: -{@$currentUserpic->thumbnailHeight/2|intval}px; margin-left: -{@$currentUserpic->thumbnailWidth/2|intval}px" />
								{else}
									<img src="{@RELATIVE_WCF_DIR}images/userpics/userpic-default.png" style="width: 200px; height: 150px; margin-left: -100px; margin-top: -75px;" alt="" />
								{/if}
							</div>
						</fieldset>
					</div>
					
					{if $this->user->getPermission('user.profile.userpic.canUploadUserpic')}
						<div class="userpicUpload">
							<fieldset>
								<legend>
									{lang}wcf.user.userpic.ownuserpic{/lang}
								</legend>
								
								<label><input onclick="if (IS_SAFARI) { enableUpload(); }" onfocus="enableUpload()" type="radio" name="userpicID" value="-1"{if $userpicID == -1} checked="checked"{/if} /> {lang}wcf.user.userpic.ownuserpic{/lang}</label>
								<div class="formFieldDesc">
									<p>{lang}wcf.user.userpic.userpicUpload.description{/lang}</p>
								</div>
								<div id="userpicUploadDiv" class="formElement{if $errorField == 'userpicUpload'} formError{/if}">
									<div class="formFieldLabel">
										<label for="userpicUpload">{lang}wcf.user.userpic.userpicUpload{/lang}</label>
									</div>
									<div class="formField">
										<input type="file" name="userpicUpload" value="" id="userpicUpload" onchange="checkUserpicUploadInput();" onkeyup="checkUserpicUploadInput();" />
										{if $errorField == 'userpicUpload'}
											<p class="innerError">
												{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
												{if $errorType == 'uploadFailed'}{lang}wcf.user.userpic.error.userpicUpload.uploadFailed{/lang}{/if}
												{if $errorType == 'baduserpic'}{lang}wcf.user.userpic.error.baduserpic{/lang}{/if}
												{if $errorType == 'notAllowedExtension'}{lang}wcf.user.userpic.error.notAllowedExtension{/lang}{/if}
												{if $errorType == 'tooLarge'}{lang}wcf.user.userpic.error.tooLarge{/lang}{/if}
												{if $errorType == 'copyFailed'}{lang}wcf.user.userpic.error.copyFailed{/lang}{/if}
											</p>
										{/if}
									</div>
								</div>
								<div id="userpicURLDiv" class="formElement{if $errorField == 'userpicURL'} formError{/if}">
									<div class="formFieldLabel">
										<label for="userpicURL">{lang}wcf.user.userpic.userpicURL{/lang}</label>
									</div>
									<div class="formField">
										<input type="text" class="inputText" name="userpicURL" value="{$userpicURL}" id="userpicURL" onkeyup="checkUserpicUploadInput();" />
										{if $errorField == 'userpicURL'}
											<p class="innerError">
												{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
												{if $errorType == 'downloadFailed'}{lang}wcf.user.userpic.error.userpicURL.downloadFailed{/lang}{/if}
												{if $errorType == 'baduserpic'}{lang}wcf.user.userpic.error.baduserpic{/lang}{/if}
												{if $errorType == 'notAllowedExtension'}{lang}wcf.user.userpic.error.notAllowedExtension{/lang}{/if}
												{if $errorType == 'tooLarge'}{lang}wcf.user.userpic.error.tooLarge{/lang}{/if}
												{if $errorType == 'copyFailed'}{lang}wcf.user.userpic.error.copyFailed{/lang}{/if}
											</p>
										{/if}
									</div>
									
								</div>				
							</fieldset>
						</div>
					{/if}
				
				</div>
				
				
				{if $additionalFields|isset}{@$additionalFields}{/if}
				
				{@SID_INPUT_TAG}
			</div>
		</div>
		<div class="formSubmit">
			<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" {if $disableUserpic}disabled="disabled"{/if}/>
			<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" />
		</div>
	</form>

</div>

{include file='footer' sandbox=false}
</body>
</html>