<?php
require_once(WCF_DIR.'lib/form/AbstractForm.class.php');

/**
 * locks an userpic
 * 
 * @author	Peter Frhwirt
 * @package	de.wbb-security.profile.userpic
 */
class UserpicLockForm extends AbstractForm {
	public $userID = 0;
	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		if(isset($_REQUEST['u'])) $this->userID = intval($_REQUEST['u']);

	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		WCF::getDB()->sendQuery("UPDATE `wcf".WCF_N."_user` SET `disableUserpic`='1' WHERE `userID`='".$this->userID."'");
		Session::resetSessions($this->userID);
		
		header("Location: index.php?page=User&userID=".$this->userID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		WCF::getUser()->checkPermission('admin.user.canEditUser');
		
		$user = WCF::getDB()->getFirstRow("SELECT `userID` FROM `wcf".WCF_N."_user` WHERE `userID`='".$this->userID."'");
		if($user['userID'] == 0) {
			require_once(WCF_DIR.'lib/system/exception/IllegalLinkException.class.php');
			throw new IllegalLinkException();
		}
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {

		if(!MODULE_USERPIC)
		{
			throw new IllegalLinkException();
		}

		self::readFormParameters();
		self::validate();
		self::save();
	}
}
?>