<?php
require_once(WCF_DIR.'lib/form/AbstractForm.class.php');
require_once(WCF_DIR.'lib/data/user/userpic/UserpicEditor.class.php');
require_once(WCF_DIR.'lib/page/util/menu/UserCPMenu.class.php');

/**
 * Shows the userpic edit form, modified AvatarEditForm (c) WoltLab GmbH
 * 
 * @author	Peter Frhwirt
 * @package	de.wbb-security.profile.userpic
 */
class UserpicEditForm extends AbstractForm {
	public $userpicID = 0;
	public $userpicUpload;
	public $userpicURL = 'http://';
	public $currentUserpic;
	public $templateName = 'userPictureEdit';
	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		if (WCF::getUser()->disableUserpic) {
			require_once(WCF_DIR.'lib/system/exception/PermissionDeniedException.class.php');
			throw new PermissionDeniedException();
		} 
		
		if (isset($_POST['userpicID'])) $this->userpicID = intval($_POST['userpicID']);
		if (isset($_POST['userpicURL'])) $this->userpicURL = StringUtil::trim($_POST['userpicURL']);
		if (isset($_FILES['userpicUpload'])) $this->userpicUpload = $_FILES['userpicUpload'];
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		// delete old userpic if necessary
		if ($this->currentUserpic && $this->currentUserpic->userID && $this->userpicID != $this->currentUserpic->userpicID) {
			$this->currentUserpic->delete();
			$this->currentUserpic = null;
		}
		
		// update user
		$sql = "UPDATE	wcf".WCF_N."_user
			SET	userpicID = ".$this->userpicID."
			WHERE	userID = ".WCF::getUser()->userID;
		WCF::getDB()->registerShutdownUpdate($sql);
		
		// reset session
		WCF::getSession()->resetUserData();
		
		// show success message
		WCF::getTPL()->assign('success', true);
		
		// reset userpic url
		$this->userpicURL = 'http://';
		
		// get object of new userpic
		if ($this->userpicID) {
			$this->currentUserpic = new UserpicEditor($this->userpicID);
		}
		else {
			$this->currentUserpic = null;
		}
		
		$this->saved();
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if ($this->userpicID) {
			if ($this->userpicID == -1) {
				// check permission
				WCF::getUser()->checkPermission('user.profile.userpic.canUploadUserpic');
				
				// upload or download userpic
				if ($this->userpicUpload && $this->userpicUpload['error'] != 4) {
					if ($this->userpicUpload['error'] != 0) {
						throw new UserInputException('userpicUpload', 'uploadFailed');
					}
				
					$this->userpicID = UserpicEditor::create($this->userpicUpload['tmp_name'], $this->userpicUpload['name'], 'userpicUpload', WCF::getUser()->userID);
				}
				else if ($this->userpicURL != 'http://') {
					if (StringUtil::indexOf($this->userpicURL, 'http://') !== 0) {
						throw new UserInputException('userpicURL', 'downloadFailed');
					}
					
					try {
						$tmpName = FileUtil::downloadFileFromHttp($this->userpicURL, 'userpic');
					}
					catch (SystemException $e) {
						throw new UserInputException('userpicURL', 'downloadFailed');
					}
					
					$this->userpicID = UserpicEditor::create($tmpName, $this->userpicURL, 'userpicURL', WCF::getUser()->userID);
				}
				else {
					throw new UserInputException('userpicUpload');
				}
			} else {
				require_once(WCF_DIR.'lib/system/exception/PermissionDeniedException.class.php');
				throw new PermissionDeniedException();
			}
		}
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		if ($this->currentUserpic && $this->currentUserpic->userID) $this->userpicID = -1;
		
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'userpicURL' => $this->userpicURL,
			'currentUserpic' => $this->currentUserpic,
			'userpicID' => $this->userpicID,
			'disableUserpic' => WCF::getUser()->disableUserpic
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		if (!WCF::getUser()->userID) {
			require_once(WCF_DIR.'lib/system/exception/PermissionDeniedException.class.php');
			throw new PermissionDeniedException();
		}
		
		// check permission
		WCF::getUser()->checkPermission('user.profile.userpic.canUploadUserpic');
		
		// set active tab
		UserCPMenu::getInstance()->setActiveMenuItem('wcf.user.usercp.menu.link.profile.userpic');
		
		$this->userpicID = WCF::getUser()->userpicID;
		if ($this->userpicID) {
			$this->currentUserpic = new UserpicEditor($this->userpicID);
		}

		if(!MODULE_USERPIC)
		{
			throw new IllegalLinkException();
		}
		
		// show form
		parent::show();
	}
}
?>