<?php
require_once(WCF_DIR.'lib/data/user/userpic/Userpic.class.php');
require_once(WCF_DIR.'lib/data/image/Thumbnail.class.php');
require_once(WCF_DIR.'lib/system/exception/UserInputException.class.php');

/**
 * UserpicEditor creates or deletes an userpic, modified userpicEditor (c) WoltLab GmbH
 * 
 * @author	Peter Frhwirt
 * @package	de.wbb-security.profile.userpic
 */
class UserpicEditor extends Userpic {
	const ALLOWED_FILE_EXTENSIONS = 'jpg,jpeg,gif,png';
	
	/**
	 * Deletes this userpic.
	 */
	public function delete() {
		// delete database entry
		$sql = "DELETE FROM	wcf".WCF_N."_user_pictures
			WHERE		userpicID = ".$this->userpicID;
		WCF::getDB()->sendQuery($sql);
		
		// delete file
		@unlink(WCF_DIR . 'images/userpics/userpic-' . $this->userpicID . '.' . $this->userpicExtension);
		@unlink(WCF_DIR . 'images/userpics/userpic.preview-' . $this->userpicID . '.' . $this->userpicExtension);
	}
	
	/**
	 * Updates the data of this userpic.
	 */
	public function update($data) {
		$updates = '';
		foreach ($data as $key => $value) {
			if (!empty($updates)) $updates .= ',';
			$updates .= $key . " = '" . $value . "'";
		}
		
		if (!empty($updates)) {
			$sql = "UPDATE	wcf".WCF_N."_userpic
				SET	".$updates."
				WHERE	userpicID = ".$this->userpicID;
			WCF::getDB()->sendQuery($sql);
		}
	}
	
	/**
	 * Creates a new userpic.
	 * 
	 * @param	string		$tmpName
	 * @param	string		$name
	 * @param	string		$field
	 * @return	integer		userpic id
	 */
	public static function create($tmpName, $name, $field, $userID = 0, $groupID = 0, $neededPoints = 0) {
		// check userpic content
		if (!ImageUtil::checkImageContent($tmpName)) {
			throw new UserInputException($field, 'baduserpic');
		}
		
		// get file extension
		$fileExtension = '';
		if (!empty($name) && StringUtil::indexOf($name, '.') !== false) {
			$fileExtension = StringUtil::toLowerCase(StringUtil::substring($name, StringUtil::lastIndexOf($name, '.') + 1));
		}
		
		// check file extension
		if (!in_array($fileExtension, explode(',', self::ALLOWED_FILE_EXTENSIONS))) {
			throw new UserInputException($field, 'notAllowedExtension');
		}
		
		// get userpic size
		list($width, $height,) = @getImageSize($tmpName);
		if (!$width || !$height) {
			throw new UserInputException($field, 'baduserpic');
		}
		
		$size = @filesize($tmpName);
		
		// generate thumbnail if necessary
		if ($width > WCF::getUser()->getPermission('user.profile.userpic.maxWidth') || $height > WCF::getUser()->getPermission('user.profile.userpic.maxHeight')) {
			$thumbnail = new Thumbnail($tmpName, WCF::getUser()->getPermission('user.profile.userpic.maxWidth'), WCF::getUser()->getPermission('user.profile.userpic.maxHeight'));
			$thumbnailSrc = $thumbnail->makeThumbnail();
			
			if ($thumbnailSrc) {
				$file = new File($tmpName);
				$file->write($thumbnailSrc);
				$file->close();
				
				// refresh userpic size
				list($width, $height,) = @getImageSize($tmpName);
				clearstatcache();
				$size = @filesize($tmpName);
				
				// get new file extension
				$fileExtension = ImageUtil::getExtensionByMimeType($thumbnail->getMimeType());
			}
			
			unset($thumbnail, $thumbnailSrc);
		}
		
		// check size again
		if ($width > WCF::getUser()->getPermission('user.profile.userpic.maxWidth') || $height > WCF::getUser()->getPermission('user.profile.userpic.maxHeight') || $size > WCF::getUser()->getPermission('user.profile.userpic.maxSize')) {
			throw new UserInputException($field, 'tooLarge');
		}
			
		// create thumbnail
			if($width > 200 OR $height > 150) {
				$thumbnail = new Thumbnail($tmpName, 200, 150);
				$thumbnailSrc = $thumbnail->makeThumbnail();
				
				if ($thumbnailSrc) {
					$file = new File(WCF_DIR.'images/userpics/userpic.preview.tmp');
					$file->write($thumbnailSrc);
					$file->close();
					
					list($thumbnailWidth, $thumbnailHeight,) = @getImageSize(WCF_DIR.'images/userpics/userpic.preview.tmp');
				}
				
				unset($thumbnail, $thumbnailSrc);
			} else {
				@copy($tmpName,WCF_DIR.'images/userpics/userpic.preview.tmp');
			}
		
		// define vars if necessary
			if(!isset($thumbnailWidth)) $thumbnailWidth = $width; 
			if(!isset($thumbnailHeight)) $thumbnailHeight = $height;	
			
		// create userpic
		$userpicID = self::insert(basename($name), array(
			'userpicExtension' => $fileExtension,
			'width' => $width,
			'height' => $height,
			'thumbnailWidth' => $thumbnailWidth,
			'thumbnailHeight' => $thumbnailHeight,
			'userID' => $userID,
			'groupID' => $groupID,
			'neededPoints' => $neededPoints
		));
		
		// copy userpic to userpic folder
		if (!copy($tmpName, WCF_DIR.'images/userpics/userpic-'.$userpicID.'.'.$fileExtension)) {
			// copy failed
			// delete userpic
			@unlink($tmpName);
			@unlink(WCF_DIR.'images/userpics/userpic.preview.tmp');
			$sql = "DELETE FROM	wcf".WCF_N."_user_pictures
				WHERE		userpicID = ".$userpicID;
			WCF::getDB()->sendQuery($sql);
			throw new UserInputException($field, 'copyFailed');
		}
		
		@rename(WCF_DIR.'images/userpics/userpic.preview.tmp',WCF_DIR.'images/userpics/userpic.preview-'.$userpicID.'.'.$fileExtension);
		
		return $userpicID;
	}
	
	/**
	 * Creates the userpic row in database table.
	 *
	 * @param 	string 		$userpicName
	 * @param 	array		$additionalFields
	 * @return	integer		new userpic id
	 */
	public static function insert($userpicName, $additionalFields = array()){ 
		$keys = $values = '';
		foreach ($additionalFields as $key => $value) {
			$keys .= ','.$key;
			$values .= ",'".escapeString($value)."'";
		}
		
		$sql = "INSERT INTO	wcf".WCF_N."_user_pictures
					(userpicName
					".$keys.")
			VALUES		('".escapeString($userpicName)."'
					".$values.")";
		WCF::getDB()->sendQuery($sql);
		return WCF::getDB()->getInsertID();
	}
}
?>