<div class="section tabularBox">
	<table class="table">
		<thead>
			<tr>
				<th class="columnID columnIdentifier" colspan="2">
					{lang}shop.acp.order.identifier{/lang}
				</th>
				
				<th class="columnText columnEnvironment">
					{lang}wcf.acp.option.shop_environment{/lang}
				</th>
				
				<th class="columnDate columnTime">
					{lang}shop.acp.order.time{/lang}
				</th>
				
				<th class="columnText columnIdentifier">
					{lang}shop.acp.invoice.convert.invoiceIdentifier{/lang}
				</th>
				
				<th class="columnText columnIdentifier">
					{lang}shop.acp.invoice.convert.invoiceIdentifierNew{/lang}
				</th>

				<th class="columnText columnAddress">
					{lang}shop.cart.address.invoice.title{/lang}
				</th>
			</tr>
		</thead>
		<tbody>
			{foreach from=$orderList item=$order}
				<tr>
					<td class="columnIcon">
						{if $order->isInvoiceConverted}
							<span class="icon icon16 fa-check jsTooltip" title="{lang}shop.acp.invoice.convert.status.done{/lang}"></span>
						{else}
							<span class="icon icon16 fa-times-rectangle jsTooltip" title="{lang}shop.acp.invoice.convert.status.pending{/lang}"></span>
						{/if}
					</td>
					<td class="columnID columnIdentifier">
						<a href="{link application='shop' controller='Order' id=$order->orderID}{/link}">{$order->identifier}</a>
					</td>
					<td class="columnText columnEnvironment">
						{lang}wcf.acp.option.shop_environment.{$order->environment}{/lang}
					</td>
					<td class="columnDate columnTime">{$order->time|plainTime}</td>
					<td class="columnText columnIdentifier">
						{if $order->isInvoiceConverted}
							{$order->originalInvoiceIdentifier}
						{else}
							<a href="{link application='shop' controller='OrderFileDownload' id=$order->orderID time=TIME_NOW type='invoice'}{/link}">{$order->invoiceIdentifier}</a>
						{/if}
					</td>
					<td class="columnText columnIdentifier">
						{if $order->isInvoiceConverted}
							<a href="{link application='shop' controller='OrderFileDownload' id=$order->orderID time=TIME_NOW type='invoice'}{/link}">{$order->invoiceIdentifier}</a><br />
							<a href="{link application='shop' controller='InvoiceConvertCancellationDownload' id=$order->orderID}{/link}" class="button small">{lang}shop.acp.invoice.convert.cancellation{/lang}</a>
						{elseif $identifiers[$order->orderID]|isset}
							{$identifiers[$order->orderID]}
						{else}
							<p class="error">{lang}shop.acp.invoice.convert.error.invalidFormat{/lang}</p>
						{/if}
					</td>
					<td class="columnText columnAddress">
						{if $order->getInvoiceAddress() !== null}
							{include file='__orderAddress' application='shop' address=$order->getInvoiceAddress() showContactInformation=true sandbox=true}
						{else}
							-
						{/if}
					</td>
				</tr>
			{/foreach}
		</tbody>
	</table>
</div>
