<html>
<head>
	<style type="text/css">{@$css}</style>
</head>

<body id="tpl{@$template|ucfirst}">
<div class="footer">
	{if SHOP_INVOICE_FOOTER_TEXT}{SHOP_INVOICE_FOOTER_TEXT|language}{/if}
</div>
<div class="company">
	{if SHOP_INVOICE_COMPANY_LOGO}
		<p><div><img class="companyLogo framed" style="max-width: 200px; max-height: 90px;" src="{@$path}images/{SHOP_INVOICE_COMPANY_LOGO}" alt="" /></div></p>
	{/if}

	<p>
		{SHOP_INVOICE_COMPANY}<br>
		{SHOP_INVOICE_COMPANY_STREET}<br>
		{SHOP_INVOICE_COMPANY_ZIPCODE} {SHOP_INVOICE_COMPANY_CITY}, {SHOP_INVOICE_COMPANY_COUNTRY|language}
	</p>

	<p>
		{if SHOP_INVOICE_COMPANY_TAX_NUMBER}{lang}shop.invoice.tax.number{/lang}: {SHOP_INVOICE_COMPANY_TAX_NUMBER}<br>{/if}
		{if SHOP_INVOICE_COMPANY_TAX_UID}{lang}shop.invoice.vat{/lang}: {SHOP_INVOICE_COMPANY_TAX_UID}{/if}
	</p>

	<p>
		{lang}shop.invoice.date{/lang}: {$order->converterCancellationTime|date}<br>
		{lang}shop.invoice.convertCancellation.id{/lang}: {$order->converterCancellationInvoiceIdentifier}<br>
		{lang}shop.invoice.orderID{/lang}: {$order->identifier}
	</p>

	<p>
		<strong>{lang}shop.invoice.contact{/lang}</strong><br>
		{if SHOP_INVOICE_CONTACT_EMAIL}{lang}shop.invoice.contact.email{/lang}: {SHOP_INVOICE_CONTACT_EMAIL}<br>{/if}
		{if SHOP_INVOICE_CONTACT_PHONE}{lang}shop.invoice.contact.phone{/lang}: {SHOP_INVOICE_CONTACT_PHONE}<br>{/if}
		{if SHOP_INVOICE_CONTACT_FAX}{lang}shop.invoice.contact.fax{/lang}: {SHOP_INVOICE_CONTACT_FAX}{/if}
	</p>
</div>

<div class="address">
	<div class="small">
		{SHOP_INVOICE_COMPANY} | {SHOP_INVOICE_COMPANY_STREET} | {SHOP_INVOICE_COMPANY_ZIPCODE} {SHOP_INVOICE_COMPANY_CITY} | {SHOP_INVOICE_COMPANY_COUNTRY|language}
	</div>

	{if !$invoiceAddress->isAnonymous}
		{if $invoiceAddress->company}
			{$invoiceAddress->company|tableWordwrap}<br>
			{if $invoiceAddress->name || $invoiceAddress->firstname}
				{$invoiceAddress->academicDegree|tableWordwrap} {$invoiceAddress->firstname|tableWordwrap} {$invoiceAddress->name|tableWordwrap}<br>
			{/if}
		{else}
			{$invoiceAddress->academicDegree|tableWordwrap} {$invoiceAddress->firstname|tableWordwrap} {$invoiceAddress->name|tableWordwrap}<br>
		{/if}

		{$invoiceAddress->street|tableWordwrap}<br>
		{$invoiceAddress->zipcode} {$invoiceAddress->city}{if $invoiceAddress->province}, {$invoiceAddress->province}{/if},
		{$invoiceAddress->country}
	{/if}
</div>

<div class="content">
	<h1>{lang}shop.invoice.convertCancellation.title{/lang}</h1>
	<strong>{lang}shop.invoice.convertCancellation.subtitle{/lang}</strong>

	<p>
		{lang}shop.invoice.convertCancellation.description{/lang}
	</p>
	
	
	<table class="productList">
		<thead>
		<tr class="head">
			<th class="product{if $order->chargeTax} productWithTax{/if}">{lang}shop.invoice.product{/lang}</th>
			<th colspan="2">{lang}shop.invoice.quantity{/lang}</th>
			<th>{lang}shop.invoice.price.single{/lang} ({$order->currency})</th>
			<th>{lang}shop.invoice.price.group{/lang} ({$order->currency})</th>
			{if $order->chargeTax}<th>{lang}shop.invoice.taxRate{/lang}</th>{/if}
		</tr>
		</thead>
		<tbody>
		{foreach from=$order->getProductList() item=$product}
			<tr>
				<td class="text" colspan="2">
					{$product->title}
					{if $product->invoiceSummary}
						<div class="small">{lang}{@$product->invoiceSummary}{/lang}</div>
					{/if}
				</td>
				<td class="integer quantity">{#$product->quantity}</td>
				<td class="integer price">{@$product->total*-1|currency}</td>
				<td class="integer price">{@$product->quantity*$product->total*-1|currency}</td>
				{if $order->chargeTax}<td class="integer price">{#$product->taxRate}%</td>{/if}
			</tr>
		{/foreach}

		{foreach from=$order->getModifierList() item=$modifier}
			<tr>
				<td class="text" colspan="2">
					{lang}{if $modifier->subject}{$modifier->subject}{else}shop.cart.checkout.sum.{@$modifier->type}{/if}{/lang}
				</td>
				<td class="integer quantity">{#$modifier->quantity}</td>
				<td class="integer price">{@$modifier->total*-1|currency}</td>
				<td class="integer price">{@$modifier->quantity*$modifier->total*-1|currency}</td>
				{if $order->chargeTax}<td class="integer price">{#$modifier->taxRate}%</td>{/if}
			</tr>
		{/foreach}
		</tbody>
	</table>

	<table class="totalList">
		<thead>
		<tr class="head">
			<th class="product"></th>
			<th>{if $order->chargeTax}{lang}shop.invoice.taxRate{/lang}{/if}</th>
			{if $order->chargeTax}
				<th>{lang}shop.invoice.sum.net{/lang} ({$order->currency})</th>
				<th>{lang}shop.invoice.sum.tax{/lang} ({$order->currency})</th>
				<th>{lang}shop.invoice.sum.gross{/lang} ({$order->currency})</th>
			{elseif $order->vat}
				<th>{lang}shop.invoice.sum.net{/lang} ({$order->currency})</th>
			{else}
				<th>{lang}shop.invoice.sum.total{/lang} ({$order->currency})</th>
			{/if}
		</tr>
		</thead>
		<tbody>
		{if $order->chargeTax}
			{foreach from=$tax key=$taxRate item=$subtotal}
				{if $taxRate != "total"}
					<tr class="small">
						<td></td>
						<td class="integer">{$taxRate}</td>
						<td class="integer">{@$subtotal['net']*-1|currency}</td>
						<td class="integer">{@$subtotal['tax']*-1|currency}</td>
						<td class="integer">{@$subtotal['gross']*-1|currency}</td>
					</tr>
				{/if}
			{/foreach}
		{/if}
		<tr class="total">
			<td></td>
			<td class="integer"><strong>{lang}shop.cart.checkout.sum{/lang}</strong></td>
			{if $order->chargeTax}
				<td class="integer">{@$tax['total']['net']*-1|currency}</td>
				<td class="integer">{@$tax['total']['tax']*-1|currency}</td>
			{/if}
			<td class="integer"><strong>{@$tax['total']['gross']*-1|currency}</strong></td>
		</tr>
		</tbody>
	</table>

	{if $order->reference}
		<p>{lang}shop.invoice.reference{/lang}: {$order->reference}</p>
	{elseif $order->paymentReference}
		<p>{lang}shop.invoice.paymentReference{/lang}: {$order->paymentReference}</p>
	{/if}

	{if $order->vat && !$order->chargeTax && $invoiceAddress->countryCode != SHOP_COUNTRY_CODE}
		<p>
			{lang}shop.invoice.legal.reverseOfCharge{/lang}<br>
			{lang}shop.invoice.legal.uid{/lang}: {$order->vat}{if $order->vatOwner} ({$order->vatOwner}){/if}
		</p>
	{/if}

	{if $smallBusinessInformation}
		<p>{@$smallBusinessInformation}</p>
	{/if}

	{if SHOP_INVOICE_TEXT}
		<p>{SHOP_INVOICE_TEXT|language}</p>
	{/if}

	{@$paymentInformationText}
</div>

<script type = "text/php">
			if (isset($pdf)) {
				$pdf->page_script('
					//if ($PAGE_COUNT > 1) {
					$font = Font_Metrics::get_font("Arial, Helvetica, sans-serif", "normal");
					$size = 10;
					$pageText = "{lang}shop.invoice.page{/lang} ".$PAGE_NUM . "/" . $PAGE_COUNT;
					$y = $pdf->get_height() - 45;
					$x = $pdf->get_width() - 46 - Font_Metrics::get_text_width($pageText, $font, $size);
					$pdf->text($x, $y, $pageText, $font, $size);
					//}
				');
			}
		</script>
</body>
</html>
