{include file="documentHeader"}
<head>
	<title>{lang}wcf.security{/lang} - {PAGE_TITLE}</title>
	{include file='headInclude' sandbox=false}
	
{if $success|isset}
	<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/TabMenu.class.js"></script>
	
	<script type="text/javascript">
		//<![CDATA[
		var tabMenu = new TabMenu();
		onloadEvents.push(function() { tabMenu.showSubTabMenu('category.system') });
		//]]>
	</script>
{/if}

</head>
<body>
{include file='header' sandbox=false}


<div id="main">
		

	
		<div class="mainHeadline">
			<img src="{@RELATIVE_WCF_DIR}icon/securitySetupL.png" alt="" />
			<div class="headlineContainer">
				<h2>{lang}wcf.security.info{/lang}</h2>
			</div>
		</div>
		
	{if $success|isset}
			<div class="border content">
				<div class="container-1">
				
				<div class="tabMenu">
					<ul>
						<li id="category.system"><a onclick="tabMenu.showSubTabMenu('category.system');"><span>{lang}wcf.security.info.category.system{/lang}</span></a></li>
						<li id="category.activation"><a onclick="tabMenu.showSubTabMenu('category.activation');"><span>{lang}wcf.security.info.category.activation{/lang}</span></a></li>
						<li id="category.update"><a onclick="tabMenu.showSubTabMenu('category.update');"><span>{lang}wcf.security.info.category.update{/lang}</span></a></li>
						<li id="category.packages"><a onclick="tabMenu.showSubTabMenu('category.packages');"><span>{lang}wcf.security.info.category.packages{/lang}</span></a></li>
					</ul>
				</div>
				<div class="subTabMenu">
					<div class="containerHead"><div> </div></div>
				</div>
				
				<div class="border tabMenuContent hidden" id="category.system-content" style="padding:0px 8px 0px 8px;">
					<fieldset>
						<legend><img src="{@RELATIVE_WCF_DIR}icon/securitySystemRunS.png" alt="" /> {lang}wcf.security.info.category.system{/lang}</legend>
					
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.installID{/lang}</div>
							<div class="formField">{$data.installID}</div>
						</div>
						
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.installTime{/lang}</div>
							<div class="formField">{@$data.installTime|time}</div>
						</div>
					
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.product{/lang}</div>
							<div class="formField">{SECURITY_PRODUCT}</div>
						</div>
							
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.version{/lang}</div>
							<div class="formField">{SECURITY_VERSION}</div>
						</div>
						
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.systemStatus{/lang}</div>
							<div class="formField">{if $data.systemStatus == 1}{lang}wcf.security.info.systemStatus.active{/lang}{else}{lang}wcf.security.info.systemStatus.inactive{/lang}{/if}</div>
						</div>
						
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.host{/lang}</div>
							<div class="formField">{ACTIVATION_HOST}</div>
						</div>
						
					</fieldset>
					
					<fieldset>
						<legend><img src="{@RELATIVE_WCF_DIR}icon/userS.png" alt="" /> {lang}wcf.security.info.category.user{/lang}</legend>
					
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.email{/lang}</div>
							<div class="formField">{MAIL_ADMIN_ADDRESS}</div>
						</div>
						
					</fieldset>
				</div>	
				
				<div class="border tabMenuContent hidden" id="category.activation-content" style="padding:0px 8px 0px 8px;">
					<fieldset>
						<legend><img src="{@RELATIVE_WCF_DIR}icon/packageTypeStandaloneS.png" alt="" /> {lang}wcf.security.info.category.activation{/lang}</legend>
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.serial{/lang}</div>
							<div class="formField">{$data.serial}</div>
						</div>	
					
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.activationID{/lang}</div>
							<div class="formField">{$data.activationID}</div>
						</div>
						
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.validity{/lang}</div>
							<div class="formField">{if $data.validity != -1}{@$data.validity|time}{else}{lang}wcf.security.info.validity.unlimited{/lang}{/if}</div>
						</div>
						
						<div class="formElement">
							<div class="formFieldLabel">{lang}wcf.security.info.customer{/lang}</div>
							<div class="formField">{$data.customer}</div>
						</div>
					</fieldset>	
					
				
					<fieldset>
						<legend><img src="{@RELATIVE_WCF_DIR}icon/securityInputS.png" alt="" /> {lang}wcf.security.info.category.activationLog{/lang}</legend>

						{foreach from=$data.activationLog item=$item}
							<div class="formElement">
								<div class="formFieldLabel">{@$item.0|shorttime}</div>
								<div class="formField">{$item.1}</div>
							</div>	
						{/foreach}

					</fieldset>	
				</div>
				<div class="border tabMenuContent hidden" id="category.update-content" style="padding:0px 8px 0px 8px;">
					<fieldset>
						<legend><img src="{@RELATIVE_WCF_DIR}icon/securityServerEncryptionS.png" alt="" /> {lang}wcf.security.info.category.update{/lang}</legend>

						{foreach from=$data.update item=$item}
							<div class="formElement">
								<div class="formFieldLabel">{@$item.0|shorttime}</div>
								<div class="formField">{$item.1}</div>
							</div>	
						{/foreach}

					</fieldset>	
				</div>
				
				<div class="border tabMenuContent hidden" id="category.packages-content" style="padding:0px 8px 0px 8px;">
					<fieldset>
						<legend><img src="{@RELATIVE_WCF_DIR}icon/packageS.png" alt="" /> {lang}wcf.security.info.category.packages{/lang}</legend>

						<div class="border">
							<table class="tableList">
					
								<tbody>
									{foreach from=$data.packages item=$package}
										<tr class="{cycle values="container-1,container-2"}">
											<td class="columnIcon">
												{if $package.standalone}
													<img src="{@RELATIVE_WCF_DIR}icon/packageTypeStandaloneS.png" alt="" title="{lang}wcf.acp.package.list.standalone{/lang}" />
												{elseif $package.plugin}
													<img src="{@RELATIVE_WCF_DIR}icon/packageTypePluginS.png" alt="" title="{lang}wcf.acp.package.list.plugin{/lang}" />
												{else}
													<img src="{@RELATIVE_WCF_DIR}icon/packageS.png" alt="" title="{lang}wcf.acp.package.list.other{/lang}" />
												{/if}
											</td>
											<td class="columnText" title="{$package.packageDescription}">{lang}wcf.acp.package.list.packageName{/lang}</td>
											<td class="columnText">{if $package.authorURL}<a href="{@RELATIVE_WCF_DIR}acp/dereferrer.php?url={$package.authorURL|rawurlencode}" class="externalURL">{$package.author}</a>{else}{$package.author}{/if}</td>
											<td class="columnText">{$package.packageVersion}</td>
											<td class="columnDate">{@$package.packageDate|date}</td>
										</tr>
									{/foreach}
								</tbody>
							</table>
						</div>
					</fieldset>	
				</div>	
					
				</div>
			</div>
	
	
	{else}
		{if $errorField}
			<p class="error">{lang}wcf.global.form.error{/lang}</p>
		{/if}
	
		<form method="post" action="index.php?form=SecurityInfo">
			<div class="border content">
				<div class="container-1">
				
						<div class="formElement{if $errorField == 'installID'} formError{/if}">
							<div class="formFieldLabel">
								<label for="installID">{lang}wcf.security.info.installID{/lang}</label>
							</div>
							<div class="formField">
								<input type="text" class="inputText" name="installID" value="{$installID}" id="installID" />
							
								{if $errorField == 'installID'}
									<p class="innerError">
										{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
										{if $errorType == 'notValid'}{lang}wcf.security.info.installID.notValid{/lang}{/if}
										{if $errorType == 'notFound'}{lang}wcf.security.info.installID.notFound{/lang}{/if}
									</p>
								{/if}
							</div>
						</div>
	
			
				</div>
			</div>
			
			<div class="formSubmit">
				<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
				<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" />
				{@SID_INPUT_TAG}
			</div>
		</form>
	{/if}

</div>


{include file='footer' sandbox=false}
</body>
</html>