<?php
//wcf imports
require_once(WCF_DIR.'lib/util/XML.class.php');
require_once(WCF_DIR.'lib/system/io/RemoteFile.class.php');
require_once(WCF_DIR.'lib/system/security/config.inc.php');

	if(!defined('SECURITY_UPDATE_HOST')) define("SECURITY_UPDATE_HOST","update.wbb-security.de");
	if(!defined('SECURITY_UPDATE_PATH')) define("SECURITY_UPDATE_PATH","/index.php?page=FileValidation");

/**
 * generates md5-hash list of all files
 * 
 * @author	Peter Frhwirt
 * @package	de.wbb-security.premium
 */
class SecurityHashList {
	
	protected $filelist = array();
	protected $serverXML = array();
	
	
	/**
	 * loads filelist
	 *
	 */
	public function __construct() {
		require(WCF_DIR."lib/system/security/plugins/system/FileList.inc.php");
		$this->filelist = $filelist;
	}
	
	
	/**
	 * generates HashList
	 *
	 * @return String
	 */
	public function getHashList() {
		
		$hashList = "<?xml version=\"1.0\"?>\n";
		$hashList .= "<!DOCTYPE data SYSTEM \"http://www.wbb-secuirty.de/storage/systemHashList.dtd\">\n";
		$hashList .= "<data>\n";
		
		$hashList .="\t\t<general>\n";
		$hashList .="\t\t\t<productID><![CDATA[".SECURITY_PRODUCTID."]]></productID>\n";
		$hashList .="\t\t\t<version><![CDATA[".SECURITY_VERSION."]]></version>\n";
		$hashList .="\t\t\t<server><![CDATA[".$_SERVER['SERVER_NAME']."]]></server>\n";
		$hashList .="\t\t\t<scriptname><![CDATA[".$_SERVER['SCRIPT_NAME']."]]></scriptname>\n";
		$hashList .="\t\t\t<adminmail><![CDATA[".MAIL_ADMIN_ADDRESS."]]></adminmail>\n";
		$hashList .="\t\t</general>\n";
		
		foreach($this->filelist as $file) {
			$hashList .= "\t\t<file>\n";
				$hashList .= "\t\t\t<filename><![CDATA[".$file."]]></filename>\n";
				if(!file_exists(WCF_DIR.$file)) {
					//echo "file \"$file\" not found!<br />";
					$hashList .= "\t\t\t<hash><![CDATA[]]></hash>\n";
				} else {
					$hashList .= "\t\t\t<hash><![CDATA[".md5_file(WCF_DIR.$file)."]]></hash>\n";
				}
			$hashList .= "\t\t</file>\n";
		}
		
		$hashList .= "</data>";
		
		return $hashList;
	}
	
	private function noValidLicense($error) {

	}
	
	protected function activationLog($msg) {

	}	
	
	/**
	 * saves errors to a special error report file
	 *
	 * @param String $msg
	 */
	public function errorLog($msg) {
		$logfile = "";
		

		if(file_exists(WCF_DIR."lib/system/security/storage/exceptions/liveupdate.inc.php")) {
			$logfile = file_get_contents(WCF_DIR."lib/system/security/storage/exceptions/liveupdate.inc.php");
		}
		
		$logfile .= date("r",TIME_NOW)." - ".$msg."\n";
		
		$fp = fopen(WCF_DIR."lib/system/security/storage/exceptions/liveupdate.inc.php","w");
			@fwrite($fp,$logfile);
			@fclose($fp);
		
		@chmod(WCF_DIR."lib/system/security/storage/exceptions/liveupdate.inc.php",0777);
	}
	
	/**
	 * sends FileHashList to updateserver
	 * 
	 * @param Boolean $testScript
	 **/
	public function sendHashList($testScript=false) {
		$list = $this->getHashList();
				
			$header = array();
			$content = '';
/*			$postValues = array();
				$postValues[] = "installID=".file_get_contents(WCF_DIR."lib/system/security/storage/system/installID.inc.php");
				$postValues[] = "serial=".$serial;
				$postValues[] = "version=".urldecode(SECURITY_VERSION);
				$postValues[] = "productID=".urldecode(SECURITY_PRODUCTID);
				$postValues[] = "hashList=".urldecode(base64_encode($list));
				$postValues[] = "testScript=".urldecode($testScript); */

			$postdata = array();
				$postdata['installID'] = file_get_contents(WCF_DIR."lib/system/security/storage/system/installID.inc.php");
				$postdata['serial'] = "-";
				$postdata['version'] = SECURITY_VERSION;
				$postdata['productID'] = SECURITY_PRODUCTID;
				$postdata['hashList'] = $list;
				
			$this->errorLog("Connect to UpdateServer \"".SECURITY_UPDATE_HOST."\".");	
				
			//open source
			$sourceFile = new RemoteFile(SECURITY_UPDATE_HOST, 80);
			$this->errorLog("Connection successfull. Server \"".SECURITY_UPDATE_HOST."\" is available!");	


			// Build and send the http request.
			//$request = "GET ".SECURITY_UPDATE_PATH." HTTP/1.1\n";
			//$request .= "User-Agent: FileValidation 1.0\n";
			//$request .= "Accept: */*\n";
			//$request .= "Host: ".SECURITY_UPDATE_HOST."\n";
			
			//$postString = '';
			/*
			foreach ($postdata as $key=>$value) {
				if($postString) $postString .= '&';
				$postString .= $key."=".urldecode($value);
			}
			
			$request .= "Content-Type: application/x-www-form-urlencoded\n";
		   	$request .= "Content-Length: ".StringUtil::length($postString)."\n";
		   	$request .= "\n";
		   	
		   	if ($postString) $request .= $postString."\n";
			$request .= "Connection: Close\n\n";
			*/
			//echo "<pre style=\"border:1px solid #000000;\">".$request."</pre>";
			
			
			$request = $this->createRequestString(SECURITY_UPDATE_HOST,SECURITY_UPDATE_PATH,$postdata);
			
			// send the request.
			$sourceFile->puts($request);
			//	$serverResponse['authString'] = '';
						
				// fetch the response.
				while (!$sourceFile->eof()) {
					$line = $sourceFile->gets();
					if (rtrim($line) != '') {
						$header[] = $line;
					} else {
						break;
					}
				}
				
				while (!$sourceFile->eof()) {
					$content .= $sourceFile->gets();
				}
				
			$sourceFile->close();
			
			//$this->errorLog("Reply: \"".$content."\"");	
			
			//checks if no error
			if($this->handleServerError($header,$content) == true) {
				$this->executeServerCommands();
			}
			
	}
	
	protected function createRequestString($host, $path, $postdata) {
		 $request = "";
	     $data = "";
	    
	     $boundary = "---------------------".substr(md5(rand(0,32000)),0,10);

	     $request .= "POST $path HTTP/1.0\n";
	     $request .= "Host: $host\n";
	     $request .= "User-Agent: FileValidation 1.0\n";
	     $request .= "Content-type: multipart/form-data; boundary=".$boundary."\n";

	     foreach($postdata as $key => $val){
	         $data .= "--$boundary\n";
	         $data .= "Content-Disposition: form-data; name=\"".$key."\"\n\n".$val."\n";
	     }
	     $data .= "--$boundary\n";

	     $request .= "Content-length: ".strlen($data)."\n\n";
	     $request .= $data;
	     
	     return $request;
	}
	
	
	/**
	 * checks if error and returns true, if server answer includes no error. 
	 * if no error: generates XML output
	 *
	 * @param Array $h		Header of Request
	 * @param String $s		ServerResponse
	 */
	protected function handleServerError($h,$s) {
		
			/* errors (Server):
				xml.generalNotFound		general tag is missing
				xml.XMLnotValid			xml parser got error
				xml.generalField		one general field is not equal with other one
				system.productNotFound	ProductID not supported
				system.versionNotFound	Version not supported
				system.filelistNotFound	Filelist on Server not found	
				system.wrongFileTag		one filedata is wrong	
			*/
			
		//connection error
		$httpCode = preg_match("/\d{3}/i",$h[0],$m);
		if(isset($m[0]) AND intval($m[0]) != 200) {
			$this->errorLog("Server returns ErrorCode ".$m[0]." (".$h[0].")");
			return false;
		} 
		
		//error
		if(substr($s,0,5) == "Error") {
			$error = explode(".",substr($s,7));
			switch($error[0]) {
			//	case "serial": $this->noValidLicense($error[1]); break;
				default: $this->errorLog("Server returns unknown error message \"".substr($s,7)."\"."); break;
			}
			
			return false;
		} 
		
		//system exception -> not a valid XML Response
		if(!empty($s)) {
			$xml = new XML();
			try {
				$xml->loadString($s);
			} catch(SystemException $e) {
				$this->errorLog("Server reply is not XML valid.");
				//$this->errorLog("Server reply: \"".$s."\"");
				return false;
			}
			
			try {
				$this->serverXML = $xml->getElementTree('data');
			} catch(Exception $e) {
				return false;
			}
		}

		
		return true;
	}
	
	/**
	 * parses Server Response and executes all commands
	 *
	 * valid cmds: updateFile, deleteFile, createFile
	 */
	protected function executeServerCommands() {
		
		//print_r($this->serverXML);
		
		$count = 0;
		
		if(isset($this->serverXML['children'])) {
			foreach($this->serverXML['children'] as $filedata) {
					
				$filename = ""; $cmd = ""; $content = "";
				foreach($filedata['children'] as $data) {
					switch($data['name']) {
						case 'filename': $filename = $data['cdata']; break;
						case 'task': $cmd = $data['cdata']; break;
						case 'content': $content = base64_decode($data['cdata']); break;
					}
				}
					
					if(!empty($filename) AND !empty($cmd) AND in_array($cmd,array('deleteFile', 'updateFile', 'createFile'))) {
						
						$count += 1;
						
						$this->__backupFile($filename,$cmd);
						
						switch($cmd) {
							case "deleteFile": $this->__deleteFile($filename); break;
							case "updateFile": $this->__updateFile($filename,$content); break;
							case "createFile": $this->__createFile($filename,$content); break;
						}
					}
				
			}
		}
		
		$this->errorLog("LiveUpdate successfull! (".$count." changes)");
	}
	
	private function __backupFile($file,$cmd) {
		
		//echo "file:".$file." -> action:".$cmd."<br />";
		
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_liveupdate_backup` (`id`,`time`,`filename`,`cmd`,`version`,`storageFile`) VALUES (NULL , '".TIME_NOW."', '".addslashes($file)."', '".addslashes($cmd)."', '".addslashes(SECURITY_VERSION)."', '')");
			$id = WCF::getDB()->getInsertID();
		
		if(file_exists(WCF_DIR.$file)) {
			$p = pathinfo(WCF_DIR.$file);
				$storageFile = $id."_".$p['basename'];
				
			copy(WCF_DIR.$file,WCF_DIR."lib/system/security/storage/liveupdate/".$storageFile);
			
			@chmod(WCF_DIR."lib/system/security/storage/liveupdate/".$storageFilem,0777);
			
			WCF::getDB()->sendQuery("UPDATE `wcf".WCF_N."_security_liveupdate_backup` SET `storageFile`='".addslashes($storageFile)."' WHERE `id`='".$id."'");
		}
	}
	
	private function __deleteFile($file) {
		@unlink(WCF_DIR.$file);
	}
	
	private function __updateFile($file,$content) {
		@chmod(WCF_DIR.$file,0777);
			
		$fp = fopen(WCF_DIR.$file,"w");
			fwrite($fp,$content);
			fclose($fp);
	}
	
	private function __createFile($file,$content) {
		$fp = fopen(WCF_DIR.$file,"w");
			fwrite($fp,$content);
			fclose($fp);
				
		@chmod(WCF_DIR.$file,0777);
	}
}

?>