<?php
require_once(WCF_DIR.'lib/system/security/SecurityHandler.class.php');
require_once(WCF_DIR.'lib/system/io/File.class.php');

/**
 * @author	Peter Frhwirt
 * @package	com.security.premium
 */
class Floodcontrol implements SecurityBuilder {
	
	protected $security;
	protected $cache = array();
	protected $cacheFile = "";
	
	protected $startTime = 0;
	
	/**
	 * @see SecurityBuilder::execute()
	 */
	public function execute($securityObj,$plugin) {	
		$this->security = $securityObj;
		/*
		$this->cacheFile = WCF_DIR."lib/system/security/cache/cache.floodcontrol.php";
		$this->loadCache();
			$this->handleCache();		
		*/
/**
	very good version, but only MySQL 5 or higher!
 
	CREATE ALGORITHM = TEMPTABLE VIEW `wcf1_security_flood_view` AS SELECT `ip` , count( 0 ) AS `count`
	FROM `wcf1_security_flood`
	WHERE (
	`timestamp` > unix_timestamp( )
	)
	GROUP BY `ip`;

		//select count
		$row = WCF::getDB()->getFirstRow("SELECT `count` FROM `wcf".WCF_N."_security_flood_view` WHERE `ip`='".$_SERVER['REMOTE_ADDR']."'");
**/	
		$row = WCF::getDB()->getFirstRow(" SELECT count( 0 ) AS `count` FROM `wcf".WCF_N."_security_flood` WHERE ( `timestamp` > unix_timestamp( ) ) AND `ip` = '".$_SERVER['REMOTE_ADDR']."' GROUP BY `ip`");
			$this->calculateFlood($row['count']);
		//dump
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_flood` (`ip`,`timestamp`) VALUES ('".$_SERVER['REMOTE_ADDR']."','".(TIME_NOW+60)."')");
	}
	
	protected function calculateFlood($count) {
		if($count) {
			if(WCF::getUser()->userID == 0) {
				if($this->security->securityConfig['floodLimitGuest'] <= $count) {
					$this->accessDenied($this->security->securityConfig['floodLimitGuest']);
				}
			} else {
				if($this->security->securityConfig['floodLimitUser'] <= $count) {
					$this->accessDenied($this->security->securityConfig['floodLimitUser']);
				}
			}
		}
	}
	
	
	protected function debug($msg) {
		if($this->startTime == 0) {
			$this->startTime = microtime();
		}
		
		if(WCF::getUser()->userID == 1) {
			echo "DEBUG: ".$msg." (exec: ".(microtime()-$this->startTime)." ms)<br />";
		}
	}
	
	protected function loadCache() {
		
		if($this->needRebuild()) {
			$this->rebuildCache();
		}
		
		ob_start();
			include($this->cacheFile);
		ob_end_clean();

	}
	
	protected function needRebuild() {
		if(!file_exists($this->cacheFile)) {
			return true;
		}
				
		if(gmdate('M-d-Y H:i',filemtime($this->cacheFile)) != gmdate('M-d-Y H:i')) {
			return true;
		}

		return false;
	}
	
	protected function rebuildCache() {
		@unlink($this->cacheFile);
			$this->cache = array();
		
		$this->writeCache();
	}
	
	protected function writeCache() {		
		$targetFile = new File($this->cacheFile);
		$targetFile->write("<?php\n/**\n* cache: floodcontrol\n* generated at ".gmdate('r')."\n* \n* DO NOT EDIT THIS FILE\n*/\n");
		$targetFile->write("\$this->cache = unserialize(base64_decode('".base64_encode(serialize($this->cache))."'));\n?>");
		$targetFile->close();
	}
	
	protected function handleCache() {
		if(isset($this->cache[$_SERVER['REMOTE_ADDR']])) {
			$this->cache[$_SERVER['REMOTE_ADDR']] += 1;
			if(WCF::getUser()->userID == 0) {
				if($this->security->securityConfig['floodLimitGuest'] <= $this->cache[$_SERVER['REMOTE_ADDR']]) {
					$this->accessDenied($this->security->securityConfig['floodLimitGuest']);
				}
			} else {
				if($this->security->securityConfig['floodLimitUser'] <= $this->cache[$_SERVER['REMOTE_ADDR']]) {
					$this->accessDenied($this->security->securityConfig['floodLimitUser']);
				}
			}
		} else {
			$this->cache[$_SERVER['REMOTE_ADDR']] = 1;
		}
				
		$this->writeCache();	
	}
	
	protected function accessDenied($limit) {
		
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_blacklist` (`id`, `object`, `value`, `status`, `validity`) VALUES (NULL , 'ip', '".addslashes($_SERVER['REMOTE_ADDR'])."', 'flood', '".(time()+$this->security->securityConfig['floodTime']*60)."')");
		WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.blacklist.php');
		
		$this->security->accessDenied("flood",array("limit"=>$limit,"expire"=>(time()+$this->security->securityConfig['floodTime']*60)));

	}
}


?>