<?php
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');
require_once(WCF_DIR.'lib/system/security/SecurityHandler.class.php');

/**
 * @author	Peter Frhwirt
 * @package	com.security.premium
 */

class SecurityLoginListener implements EventListener {
	
	var $validSession = 0;
	
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		
		require(WCF_DIR.'lib/system/security/config.inc.php');
		require(WCF_DIR.'lib/system/security/plugins/acp/config.inc.php');

		if($activePlugin == 1 AND $config['login'] == 1) {
			WCF::getTPL()->assign(array('errorField' => '','errorType' => '', 'username' => '', 'url' => ''));
			if(isset($_REQUEST['event']) AND $_REQUEST['event'] == "SecurityLogin") {			
				if(!$this->checkSession()) {
					self::login();
				}
			}
		
			if(!$this->checkSession()) {
				self::showLogin();
			}
		}
	}
	
	protected function checkSession() {
		
		if($this->validSession == 1) return 1;
		
		$session = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_sessions` WHERE `sessionID`='".addslashes(SID)."' AND `ipAddress`='".addslashes($_SERVER['REMOTE_ADDR'])."' AND `validity` >= '".time()."'");
			if(isset($session['id']) AND $session['id'] > 0) { $this->validSession = 1; return 1; } else { return 0; }
	}
	
	
	protected function generateToken() {
		$token = md5(microtime().uniqid());
			$this->saveToken($token);
		
		return $token;
	}
	
	
	protected function saveToken($token) {
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_tokens` (`id`, `token`, `page`,`validity`) VALUES (NULL , '".addslashes($token)."', 'LoginForm', '".(time()+3600)."')");
	}
	
	protected function showLogin() {
		
		if(isset($_REQUEST['url'])) {
			WCF::getSession()->register('securityAdminURL',$_REQUEST['url']);
		} 
		
		WCF::getTPL()->assign(array(
			'token' => $this->generateToken(),
			'standardLogin' => $this->standardLogin()
		));
		
		WCF::getTPL()->display('securityLogin');
		exit;
	}
	
	protected function standardLogin() {
		$user = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_accounts` WHERE `username`='Administrator'");
		if(md5($user['checksum'].md5('password')) == $user['password']) {
			return 1;
		}
			
		return 0;
	}
	
	protected function login() {
		
		
		$input = array();
		foreach(array("username","password","token","packageID","url","s") as $key) {
			if(isset($_POST[$key])) $input[$key] = $_POST[$key];
			  else $input[$key] = "";
		}	
		
		WCF::getTPL()->assign(array('username' => $input['username'],'url' => $input['url']));
		
		$checksum = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_tokens` WHERE `token`='".addslashes($input['token'])."' AND `validity` >= '".time()."' AND `page`='LoginForm'");
		if($checksum['id'] == 0) {
			WCF::getTPL()->assign(array('errorField' => 'token','errorType' => 'notValid'));
			self::showLogin();
		}
		
		WCF::getDB()->sendQuery("DELETE FROM `wcf".WCF_N."_security_tokens` WHERE `token`='".addslashes($input['token'])."' OR `validity` < '".time()."'");
		
		if(empty($input['username'])) {
			WCF::getTPL()->assign(array('errorField' => 'username','errorType' => 'empty'));
			self::showLogin();
		}
		
		if(empty($input['password'])) {
			WCF::getTPL()->assign(array('errorField' => 'password','errorType' => 'empty'));
			self::showLogin();
		}
		
		$user = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_accounts` WHERE `username`='".addslashes($input['username'])."'");
		
		if($user['id'] == 0) {
			WCF::getTPL()->assign(array('errorField' => 'username','errorType' => 'notFound'));
			self::showLogin();
		} elseif($user['password'] != md5($user['checksum'].md5($input['password']))) {

			WCF::getDB()->sendQuery("UPDATE `wcf".WCF_N."_security_accounts` SET `accessErrors`='".($user['accessErrors']+1)."' WHERE `id`='".$user['id']."'");
			WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_accounts_errors` (`id`, `account`, `time`, `ipAddress`, `host`, `browser`) VALUES (NULL , '".$user['id']."', '".time()."', '".addslashes($_SERVER['REMOTE_ADDR'])."', '".addslashes(gethostbyaddr($_SERVER['REMOTE_ADDR']))."', '".addslashes($_SERVER['HTTP_USER_AGENT'])."')");
			
			WCF::getTPL()->assign(array('errorField' => 'password','errorType' => 'false'));
			self::showLogin();
		}
						
		WCF::getDB()->sendQuery("UPDATE `wcf".WCF_N."_security_accounts` SET `ipAddress`='".addslashes($_SERVER['REMOTE_ADDR'])."', `host`='".addslashes(gethostbyaddr($_SERVER['REMOTE_ADDR']))."' WHERE `id`='".$user['id']."'");
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_sessions` (`id`, `sessionID`, `ipAddress`, `validity`) VALUES (NULL , '".SID."', '".addslashes($_SERVER['REMOTE_ADDR'])."', '".(time()+120)."')");
		
		
		header("Location: index.php?form=Login&packageID=".PACKAGE_ID."&url=".urlencode(WCF::getSession()->getVar('securityAdminURL'))."&s=".SID);
		exit;
	}
	
}
?>