<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/data/message/bbcode/BBCodeParser.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityHelpPage extends AbstractPage {
	public $templateName = 'securityHelp';
	public $activeMenuItem = 'wcf.acp.menu.link.security.service.help';
	public $neededPermissions = 'admin.security.canViewHelp';
	
	protected $language = "de";
	protected $page = "index";
	
	protected $pages = array();
	protected $pageData = array();
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		$this->language = WCF::getLanguage()->getLanguageCode();
		
		if(isset($_REQUEST['doc'])) {
			$doc = explode(".",$_REQUEST['doc']);
				$this->language = $doc[0]; unset($doc[0]);
				$this->page = implode(".",$doc);
		}
	}

	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
			
		$result = WCF::getDB()->sendQuery("SELECT node1.*, COUNT(*) AS level FROM `wcf".WCF_N."_security_help` AS node1, `wcf".WCF_N."_security_help` AS node2 WHERE node1.lang='".addslashes($this->language)."' AND node1.lft BETWEEN node2.lft AND node2.rgt GROUP BY node1.LFT");
		while($row = WCF::getDB()->fetchArray($result)) {
			if($row['page'] == $this->page) { 
				WCF::getCache()->addResource('bbcodes', WCF_DIR.'cache/cache.bbcodes.php', WCF_DIR.'lib/system/cache/CacheBuilderBBCodes.class.php');
				WCF::getCache()->addResource('smilies', WCF_DIR.'cache/cache.smilies.php', WCF_DIR.'lib/system/cache/CacheBuilderSmilies.class.php');
						
				$parser = new BBCodeParser('text/html');
				
				if(empty($row['file'])) {
					$row['content'] = str_replace("\n","<br />",trim($parser->parse($row['content'])));	
				} else {
					$row['content'] = str_replace("\n","<br />",trim($parser->parse(utf8_encode(file_get_contents(WCF_DIR.$row['file'])))));				
				}
				$this->pageData = $row;
			}
			
			$row['space'] = ($row['level']-2) * 24;
			$this->pages[] = $row;
		}
		
		if(!isset($this->pageData['id']) OR $this->pageData['id'] == 0) {
			
			$otherLang = array();
			
			$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_help` WHERE `page`='".addslashes($this->page)."'");
			while($row = WCF::getDB()->fetchArray($result)) {
				$otherLang[] = $row;
			}
			
			WCF::getTPL()->assign(array(
				'otherLang' => $otherLang,
			));
		}
	}
	
	protected function getPath() {
		if(count($this->pageData) == 0) {
			return array();
		}
		
		$path = array();
		foreach($this->pages as $item) {
			$path[$item['level']] = $item;
			
			if($item['id'] == $this->pageData['id']) {
				$returnPath = array();
				
				for($i=1;$i<$item['level'];$i++) {
					if(isset($path[$i])) $returnPath[] = $path[$i];
				}
				
				return $returnPath;
			}
		}
	}
	
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		
		// enable menu item
		if (!empty($this->activeMenuItem)) WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		
		// check permission
		if (!empty($this->neededPermissions)) WCF::getUser()->checkPermission($this->neededPermissions);
		
		
		// show page
		parent::show();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'pages' => $this->pages,
			'pageData' => $this->pageData,
			'path' => $this->getPath()
		));
	}
}
?>