<?php
require_once(WCF_DIR.'lib/page/SortablePage.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityAccessPage extends SortablePage {
	public $itemsPerPage = 40;
	public $templateName = 'securityAccess';
	public $neededPermissions = 'admin.security.canViewAccess';
	
	public $accounts = array();
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
	}
	
	/**
	 * @see SortablePage::validateSortField()
	 */
	public function validateSortField() {
		parent::validateSortField();
		
		switch ($this->sortField) {
			case 'id': $this->sortField = 'id'; break;
			case 'username': $this->sortField = 'username'; break;
			case 'ipAddress': $this->sortField = 'ipAddress'; break;
			default: $this->sortField = 'username';
		}
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		if(isset($_REQUEST['sortField'])) { $this->sortField = $_REQUEST['sortField']; } else { $this->sortField = "username"; }
		if(isset($_REQUEST['sortOrder'])) { $this->sortOrder = $_REQUEST['sortOrder']; } else { $this->sortOrder = "DESC"; }
		
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_accounts`  ORDER BY `".$this->sortField."` ".$this->sortOrder."  LIMIT ".$this->itemsPerPage." OFFSET ".($this->pageNo - 1) * $this->itemsPerPage);
		while($row = WCF::getDB()->fetchArray($result)) {
			$this->accounts[$row['id']] = $row;
		}
		
		if(isset($_REQUEST['action']) AND isset($_REQUEST['id']) AND $_REQUEST['action'] == "delete" AND intval($_REQUEST['id'])) {
			
			//permissions
			WCF::getUser()->checkPermission('admin.security.canDeleteAccess');
			
			if(count($this->accounts) <= 1 OR !isset($this->accounts[intval($_REQUEST['id'])])) {
				require_once(WCF_DIR.'lib/system/exception/IllegalLinkException.class.php');
				throw new IllegalLinkException();
			}
			
			WCF::getDB()->sendQuery("DELETE FROM `wcf".WCF_N."_security_accounts` WHERE `id`='".intval($_REQUEST['id'])."'");
			header("Location: index.php?page=SecurityAccess&packageID=".PACKAGE_ID."&s=".SID);
			exit;
		}
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$tableFields = array(); $fields = array("id","username","ipAddress");
		foreach($fields as $field) {
			$tableFields[] = array("field"=>$field,"name"=>"wcf.acp.security.access.".$field);
		}
		
		WCF::getTPL()->assign(array(
			'accounts' => $this->accounts,
			'fields' => $fields,
			'tableHeader' => $tableFields
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		WCFACP::getMenu()->setActiveMenuItem('wcf.acp.menu.link.security.config.access');
		
		// check permission
		if(!empty($this->neededPermissions)) {
			WCF::getUser()->checkPermission($this->neededPermissions);
		}
		
		parent::show();
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();

		$row = WCF::getDB()->getFirstRow("SELECT count(*) as `count` FROM `wcf".WCF_N."_security_accounts`");
		WCF::getTPL()->assign(array('count' => $row['count']));
		return $row['count'];
	}
}
?>