<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');
require_once(WCF_DIR.'lib/system/security/plugins/system/SecurityFileParser.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityExceptionsForm extends ACPForm {
	public $templateName = 'securityException';
	public $activeMenuItem = 'wcf.acp.menu.link.security.config.exceptions';
	public $neededPermissions = 'admin.security.canEditExceptions';
	
	protected $file = "";
	protected $setExceptions = array();
	
	protected $classType = "";
	protected $classFile = "";

	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
				
		foreach($this->getPlugins() as $plugin) {
			unset($activePlugin,$config,$fields,$exceptions,$package);
			require_once(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
			
			if(isset($exceptions) AND count($exceptions) > 0) {
				foreach($exceptions as $file=>$value) {
					if(!isset($this->setExceptions[$file])) {
						$this->setExceptions[$file] = array("type"=>$this->getClassType($file),"plugins"=>array());
					}
					
					$this->setExceptions[$file]['plugins'][] = $plugin;
				}
			}
		}
		
		
		array_multisort($this->setExceptions,1);
	}
	
	protected function getPlugins() {
		$plugins = array();
		
		foreach(scandir(WCF_DIR."lib/system/security/plugins/") as $plugin) {
			if($plugin != "." AND $plugin != ".." AND file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php") AND !file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/__config.lock")) {
				$plugins[] = $plugin;
			}
		}
		
		return $plugins;
	}
	
	/**
	 * @see Page::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		if(isset($_REQUEST['file'])) $this->file = $_REQUEST['file'];
		
	}
	
	protected function getClassType($classFile) {
		
		return SecurityFileParser::getClassType($classFile);
		
		/*
 		if(substr($classFile,-5,5) == "Action") {
 			return "action";
 		} elseif(substr($classFile,-4,4) == "Form") {
 			return "form";
 		} elseif(substr($classFile,-4,4) == "Page") {
 			return "page";
 		} else {
 			return "";
 		} */
	} 
	
	
	protected function parseFileInput() {
		
		$classFile = SecurityFileParser::getClassFile($this->file);
		if(!empty($classFile)) {
			
			$this->classFile = $classFile;
			$this->classType = SecurityFileParser::getClassType($classFile);
			
			return true;
		} else {
			return false;
		}
		
		/*
		$this->file = str_replace("\\","/",$this->file);
		
		//url
		if(preg_match("/^(http|https|ftp):\/\/((?:[a-zA-Z0-9_-]+\.?)+):?(\d*)/",$this->file,$m)) {			
			$this->file = explode("#",$this->file);
			$serverstring = explode("?",$this->getLastItem($this->file[0],"/"));
			if(!isset($serverstring[1]) OR empty($serverstring[1])) {
				if($serverstring[0] == "index.php" OR empty($serverstring[0])) {
					$this->classFile = "IndexPage";
					$this->classType = "page";
					
					return true;
				} else {
					return false;
				}
			}
			
			$args = explode("&",$serverstring[1]);
			foreach($args as $item) {
				$item = explode("=",$item);
				
				if($item[0] == "page" OR $item[0] == "form" OR $item[0] == "action") {
					$this->classType = $item[0];
					$this->classFile = $item[1].ucfirst($item[0]);
					return true;
				}
			}

		//path
 		} elseif(ereg("\/",$this->file)) {
 			$file = $this->getLastItem($this->file,"/");
 			if(substr($file,-10,10) == ".class.php") {
 				$this->classFile = str_replace(".class.php","",$file);
  			
 				$classType = $this->getClassType($this->classFile);
 				if(empty($classType)) {
 					return false;
 				} else {
 					$this->classType = $classType;
 					return true;
 				} 
 			} 
 			
 		//class
 		} else {
 			$this->classFile = $this->file;
 			if(substr($this->file,-5,5) == "Action") {
 				$this->classType = "action";
 				return true;
 			} elseif(substr($this->file,-4,4) == "Form") {
 				$this->classType = "form";
 				return true;
 			} elseif(substr($this->file,-4,4) == "Page") {
 				$this->classType = "page";
 				return true;
 			} 
 		}
		
		return false; */
	}
	/*
	protected function getLastItem($item,$seperator) {
		$array = explode($seperator,$item);
		return $array[(count($array)-1)];
	} */
	
	protected function searchFile() {
	
		$package = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_package` WHERE `packageID`='".intval(PACKAGE_ID)."'");
		if(!empty($package['packageDir'])) {
			if(file_exists(WCF_DIR.$package['packageDir']."lib/".$this->classType."/".$this->classFile.".class.php")) {
				return true;
			}
		}
		
		//wcf
		if(file_exists(WCF_DIR."lib/".$this->classType."/".$this->classFile.".class.php")) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if(empty($this->file)) {
			throw new UserInputException('file');
		}
		
		if(!$this->parseFileInput()) {
			throw new UserInputException('file', 'notValid');
		}

		if(!$this->searchFile()) {
			throw new UserInputException('file', 'notFound');
		}

	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		header("Location:index.php?form=SecurityExceptionsEdit&classFile=".$this->classFile."&classType=".$this->classType."&packageID=".PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'file' => $this->file,
			'setExceptions' => $this->setExceptions
		));
	}
}
?>