/**
 * @author	Peter Fruehwirt
 */
function SecurityBlackListEdit(data, count, additionalOptions) {
	this.data = data;
	this.count = count;
	this.additionalOptions = additionalOptions;
	
	/**
	 * Saves the marked status.
	 */
	this.saveMarkedStatus = function(data) {
		var ajaxRequest = new AjaxRequest();
		ajaxRequest.openPost('index.php?page=SecurityBlacklistAction'+SID_ARG_2ND, data);
	}
	
	/**
	 * Returns a list of the edit options for the edit menu.
	 */
	this.getEditOptions = function(id) {
		return new Array();
	}
	
	/**
	 * Returns a list of the edit options for the edit marked menu.
	 */
	this.getEditMarkedOptions = function() {
		var options = new Array();
		var i = 0;
		
		options[i] = new Object();
		options[i]['function'] = 'securityBlackListEdit.removeMarked();';
		options[i]['text'] = language['wcf.global.button.delete'];
		options[i]['className'] = 'bottomSeparator';
		i++;
		
		options[i] = new Object();
		options[i]['function'] = 'securityBlackListEdit.blockMarked();';
		options[i]['text'] = language['wcf.acp.security.blacklist.blockMarked'];
		i++;
		
		options[i] = new Object();
		options[i]['function'] = 'securityBlackListEdit.ignoreMarked();';
		options[i]['text'] = language['wcf.acp.security.blacklist.ignoreMarked'];
		options[i]['className'] = 'bottomSeparator';
		i++;
		
		// additional options
		for (var j = 0; j < this.additionalOptions.length; j++) {
			options[i] = new Object();
			options[i]['function'] = this.additionalOptions[j]['function'];
			options[i]['text'] = this.additionalOptions[j]['text'];
			if (this.additionalOptions[j]['className']) options[i]['className'] = this.additionalOptions[j]['className'];
			i++;
		}
		
		// unmark all
		options[i] = new Object();
		options[i]['function'] = 'securityBlackListEdit.unmarkAll();';
		options[i]['text'] = language['wcf.global.button.unmark'];
		i++;
		
		return options;
	}
	
	/**
	 * Ummarked all marked pms.
	 */
	this.unmarkAll = function() {
		var ajaxRequest = new AjaxRequest();
		ajaxRequest.openGet('index.php?page=SecurityBlacklistAction&action=unmarkAll'+SID_ARG_2ND);
		
		this.removeMarks();
	}
	

	/**
	 * Deletes the marked messages.
	 */
	this.removeMarked = function() {
		if (confirm(language['wcf.acp.security.blacklist.deleteMarked.sure'])) {
			document.location.href = fixURL('index.php?page=SecurityBlacklistAction&action=deleteMarked'+SID_ARG_2ND);
		}
	}
	
	this.blockMarked = function() {
		document.location.href = fixURL('index.php?page=SecurityBlacklistAction&action=blockMarked'+SID_ARG_2ND);
	}
	
	this.ignoreMarked = function() {
		document.location.href = fixURL('index.php?page=SecurityBlacklistAction&action=ignoreMarked'+SID_ARG_2ND);
	}
	
	this.removeMarks = function() {
		// checkboxes
		this.count = 0;
		for (var id in this.data) {
			this.data[id]['isMarked'] = 0;
			var checkbox = document.getElementById('blacklistMark' + id);
			if (checkbox) {
				checkbox.checked = false;
			}
			
			this.showStatus(id);
		}
		
		// mark all checkbox
		this.parentObject.checkMarkAll(false);
		
		// edit marked menu
		this.parentObject.showMarked();
	}
	
	/**
	 * Returns the title for the marked message box.
	 */
	this.getMarkedTitle = function() {
		return eval(language['wcf.acp.security.blacklist.markedItems']);
	}
	
	/**
	 * Shows the status of a message.
	 */
	this.showStatus = function(id) {
		// get row
		var row = document.getElementById('blacklistRow'+id);
		
		// update css class
		if (row) {
			// get class
			var className = row.className;
		
			// original className
			if (this.data[id]['class'] != className) {
				className = this.data[id]['class'];
			}
			
			// marked
			if (this.data[id]['isMarked']) {
				// add marked class
				className += ' marked';
			}
			
			row.className = className;
		}
	}
	
	this.parentObject = new InlineListEdit('blacklist', this);
}