{include file='header'}

<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/AjaxRequest.class.js"></script>
<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/InlineListEdit.class.js"></script>
<script type="text/javascript" src="{@RELATIVE_WCF_DIR}acp/js/SecurityAttackListEdit.class.js"></script>

<script type="text/javascript">
	//<![CDATA[
	// data array
	var attackData = new Array();
	
	// additional options
	var additionalOptions = new Array();
	
	// language
	var language = new Object();
	language['wcf.global.button.mark'] = '{lang}wcf.global.button.mark{/lang}';
	language['wcf.global.button.unmark'] = '{lang}wcf.global.button.unmark{/lang}';
	language['wcf.global.button.delete'] = '{lang}wcf.global.button.delete{/lang}';
	language['wcf.acp.security.attacks.downloadMarked'] = '{lang}wcf.acp.security.attacks.downloadMarked{/lang}';
	language['wcf.acp.security.attacks.deleteMarked.sure']	= '{lang}wcf.acp.security.attacks.deleteMarked.sure{/lang}';
	language['wcf.acp.security.attacks.markedAttacks'] = '{lang}wcf.acp.security.attacks.markedAttacks{/lang}';
	
	onloadEvents.push(function() { securityAttackListEdit = new SecurityAttackListEdit(attackData, {@$markedJournals}, additionalOptions); });

	function hideContent(key) {
		var image = document.getElementById(key + 'Image');
		var content = document.getElementById(key + 'Content');
		
		if(content.className == "hidden") {
			image.src = "{@RELATIVE_WCF_DIR}icon/minusS.png";
			content.className = "";
		} else {
			image.src = "{@RELATIVE_WCF_DIR}icon/plusS.png";
			content.className = "hidden";
		}
	}
	
	//]]>
</script>

<div class="mainHeadline">
	<img src="{@RELATIVE_WCF_DIR}icon/securityAttacksL.png" alt="" />
	<div class="headlineContainer">
		<h2>{lang}wcf.acp.security.attacks{/lang}</h2>
		<p></p>
	</div>
</div>

	<div class="border content">
		<div class="container-1">
				
			<label><input name="attackMarkAll" type="checkbox" /> {lang}wcf.acp.security.attacks.markAll{/lang}</label>
		
			{foreach from=$attacks key=type item=attackType}
				<div class="message content">
					<div class="messageInner container-1">
						<h4 class="subHeadline"><img src="{@RELATIVE_WCF_DIR}icon/minusS.png" alt="" onclick="javascript:hideContent('{$type}');" id="{$type}Image" /> {lang}wcf.acp.security.attacks.type.{$type}{/lang} ({$attackType|count})</h3>
						<div class="messageBody">
							
							<div id="{$type}Content" class="">
								{if $attackType|count > 0}
									<table class="tableList border">
										<tbody>
											{foreach from=$attackType item=item}
												<tr id="attackRow{$item.id}" class="{cycle values="container-1,container-2" advance=false}">
													<td valign="top"><input type="checkbox" name="attackJournalID" id="attackMark{$item.id}" value="1" /></td>
													<td style="width:100%;">
														{@$item.time|time} - {$item.ipAddress} [{$item.host}]
														<p class="light smallFont">{$item.browser}</p>
														
														<script type="text/javascript">
														//<![CDATA[
															attackData[{$item.id}] = new Object();
															attackData[{$item.id}]['isMarked'] = {@$item.isMarked};
															attackData[{$item.id}]['class'] = '{cycle values="container-1,container-2"}';
														//]]>
														</script>
													</td>
													<td valign="top"><a href="index.php?page=SecurityAttacksAction&amp;action=download&amp;attackID={$item.id}&amp;packageID={@PACKAGE_ID}{@SID_ARG_2ND}"><img src="{@RELATIVE_WCF_DIR}icon/securityAttacksLogS.png" alt="" /></a></td>
												</tr>
											{/foreach}
										</tbody>
									</table>
								{else}	
									<p class="light smallFont">{lang}wcf.acp.security.attacks.noResults{/lang}</p>
								{/if}
							</div>
							
						</div>
					</div>
				</div>
			{/foreach}

		</div>
	</div>
	
	<div class="contentFooter">
		 <div id="attackEditMarked" class="optionButtons"></div>
	</div>


{include file='footer'}