<?php

class SecurityFileParser {
	
	/**
	 * returns the classType of a file
	 *
	 * @param String $classFile
	 * @return String
	 */
	public static function getClassType($classFile) {
 		if(substr($classFile,-5,5) == "Action") {
 			return "action";
 		} elseif(substr($classFile,-4,4) == "Form") {
 			return "form";
 		} elseif(substr($classFile,-4,4) == "Page") {
 			return "page";
 		} 
 		
 		return "";
	}
	
	/**
	 * returns the last item of an String seperated by a seperator
	 *
	 * @param String $item
	 * @param String $seperator
	 * @return String
	 */
	public static function getLastItem($item,$seperator) {
		$array = explode($seperator,$item);
		return array_pop($array);
	}

	public static function getClassFile($file) {
		
		$file = str_replace("\\","/",$file);
		
		//url
		if(preg_match("/^(http|https|ftp):\/\/((?:[a-zA-Z0-9_-]+\.?)+):?(\d*)/",$file,$m)) {			
			$file = explode("#",$file);
			$serverstring = explode("?",self::getLastItem($file[0],"/"));
			if(!isset($serverstring[1]) OR empty($serverstring[1])) {
				if($serverstring[0] == "index.php" OR empty($serverstring[0])) {
					return "IndexPage";
				} else {
					return "";
				}
			}
			
			$args = explode("&",$serverstring[1]);
			foreach($args as $item) {
				$item = explode("=",$item);
				
				if($item[0] == "page" OR $item[0] == "form" OR $item[0] == "action") {
					return $item[1].ucfirst($item[0]);
				}
			}

		//path
 		} elseif(ereg("\/",$file)) {
 			$file = self::getLastItem($file,"/");
 			if(substr($file,-10,10) == ".class.php") {
 				return str_replace(".class.php","",$file);
 			}
 			
 		//class
 		} elseif(ereg("[a-zA-Z0-9]",$file)) {
 			if(substr($file,-5,5) == "Action") {
 				return $file;
 			} elseif(substr($file,-4,4) == "Form") {
 				return $file;
 			} elseif(substr($file,-4,4) == "Page") {
 				return $file;
 			} 
 		}
 		
 		return "";
	}
}

?>
