<?php
require_once(WCF_DIR.'lib/system/security/SecurityHandler.class.php');

/**
 * @author	Peter Frhwirt
 * @package	com.security.premium
 */
class Datatransfer implements SecurityBuilder {
	
	protected $security;
	
	/**
	 * @see SecurityBuilder::execute()
	 */
	public function execute($securityObj,$plugin) {
		
		if($securityObj->checkReferer()) {
			$this->logIncome();
		}		
	}
	
	
	protected function logIncome() {
		if($this->validURL($_SERVER['HTTP_REFERER'])) {
			
			$entry = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_income` WHERE `referer`='".addslashes($_SERVER['HTTP_REFERER'])."' AND `request`='".addslashes($_SERVER['REQUEST_URI'])."' AND `time`>='".(TIME_NOW-60)."'");
			if($entry['id'] == 0) {	
				require(WCF_DIR."lib/system/security/plugins/datatransfer/config.inc.php");
				if(isset($config['TransferLoadIcons']) AND $config['TransferLoadIcons'] == 1) {
					$this->loadIcon($_SERVER['HTTP_REFERER']);
				}
				
				WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_income` (`id`, `referer`, `request`, `time`) VALUES (NULL , '".addslashes($_SERVER['HTTP_REFERER'])."', '".addslashes($_SERVER['REQUEST_URI'])."', '".TIME_NOW."')");
			}
		}
	}
		
	
	protected function validURL($url) {
		if(preg_match("/(?#WebOrIP)((?#protocol)((http|https):\/\/)?(?#subDomain)(([a-zA-Z0-9]+\.(?#domain)[a-zA-Z0-9\-]+(?#TLD)(\.[a-zA-Z]+){1,2})|(?#IPAddress)((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])))+(?#Port)(:[1-9][0-9]*)?)+(?#Path)((\/((?#dirOrFileName)[a-zA-Z0-9_\-\%\~\+]+)?)*)?(?#extension)(\.([a-zA-Z0-9_]+))?(?#parameters)(\?([a-zA-Z0-9_\-]+\=[a-z-A-Z0-9_\-\%\~\+]+)?(?#additionalParameters)(\&([a-zA-Z0-9_\-]+\=[a-z-A-Z0-9_\-\%\~\+]+)?)*)?/i",$url)) {
			return true;
		}
		
		return false;
	}
	
	protected function loadIcon($url) {
		$url = parse_url($url);
		$file = $url['scheme']."://".$url['host']."/favicon.ico";
		
		if(!file_exists(WCF_DIR.'images/security/icon/'.$url['host'].'.ico')) {
			if (function_exists('fopen') && ini_get('allow_url_fopen')) {
				try {
					$remoteFile = new File($file, 'rb'); 
					if (isset($remoteFile)) {
						$filename = FileUtil::downloadFileFromHttp($file, 'transferIcon');
						
						$fp = @fopen(WCF_DIR.'images/security/icon/'.$url['host'].'.ico','w');
						if(is_resource($fp)) {
							fwrite($fp,file_get_contents($filename));
							fclose($fp);
							
							@chmod(WCF_DIR.'images/security/icon/'.$url['host'].'.ico',0777);
						}
					}
				} catch (SystemException $e) {
					//nothing...
				}
			} 
		}
	}
}


?>