<?php
require_once(WCF_DIR.'lib/system/security/SecurityBuilder.class.php');

/**
 * SecurityHandler holds all registered security resources.
 * 
 * @package	de.wbb-security.premium
 * @author	Peter Frhwirt
 * 
 * @todo honeypot with robot.txt to bad dir. ref blacklist
 * 		 new plugins -> add to system
 * 		 Dateiausnahmenimportfuntkion
 * 		 Serverauslastung messen und grafisch augeben
 * 		 $_POST in Systemlogs optional sichern
 */

final class SecurityHandler {

	protected $securityResources = array();
	public $securityConfig = array();
	protected $objects = array();
	
	protected $shutdown = 0;
	
	public function __construct() {
		$this->config();
	}
	
	protected function config() {
		//$this->staticConfig();
		
		//global config
		require_once(WCF_DIR.'lib/system/security/config.inc.php');
		
		/*
		//$this->securityConfig['blacklist'] = 1; //forward to other Page
		//$this->securityConfig['floodcontrol'] = 1;
		//$this->securityConfig['floodLimitUser'] = 60;
		//$this->securityConfig['floodLimitGuest'] = 30;
		//$this->securityConfig['floodTime'] = 180;
		$this->securityConfig['whitelist'] = 1; // ?????
		//$this->securityConfig['honeypot'] = 1;
		//$this->securityConfig['scriptblocker'] = 1;
		//$this->securityConfig['datatransfer'] = 1;
		//$this->securityConfig['userWarnings'] = 1;
		//$this->securityConfig['userAccess'] = 1;
		//$this->securityConfig['userHistory'] = 1;
		//$this->securityConfig['systemlogs'] = 1;
		//$this->securityConfig['xss'] = 1; */

		//$this->accessDenied("blacklist",array()); 
		
		/** needed for a working system **/
		$this->securityConfig['systemFile'] = WCF_DIR."lib/system/security/cache/cache.system.php";

		WCF::getTPL()->assign(array(
			'securityConfig' => $this->securityConfig
		));
	}
		
	protected function staticConfig() {
		
	}
	
	public function systemCore() {				
		if($this->activeSystem() == 1) {
			$this->addResource("blacklist",WCF_DIR."lib/system/security/plugins/blacklist/blacklist.class.php","Blacklist");
			$this->addResource("floodcontrol",WCF_DIR."lib/system/security/plugins/floodcontrol/floodcontrol.class.php","Floodcontrol");
			//$this->addResource("userAccess",WCF_DIR."lib/system/security/plugins/userAccess/userAccess.class.php","Access");
			$this->addResource("scriptblocker",WCF_DIR."lib/system/security/plugins/scriptblocker/scriptblocker.class.php","Scriptblocker");
		
			$this->fireActions();
		}
	}
	
	public function extendedSystem() {
		if($this->activeSystem() == 1) {
			//$this->addResource("ssl",WCF_DIR."lib/system/security/plugins/ssl/ssl.class.php","SSL");
			//$this->addResource("userHistory",WCF_DIR."lib/system/security/plugins/userHistory/history.class.php","History");
			//$this->addResource("systemlogs",WCF_DIR."lib/system/security/plugins/systemlogs/systemlogs.class.php","Systemlogs");
			$this->addResource("datatransfer",WCF_DIR."lib/system/security/plugins/datatransfer/datatransfer.class.php","Datatransfer");
			//$this->addResource("honeypot",WCF_DIR."lib/system/security/plugins/honeypot/honeypot.class.php","Honeypot");
			//$this->addResource("userWarnings",WCF_DIR."lib/system/security/plugins/userWarnings/userwarnings.class.php","UserWarnings");
			//$this->addResource("sqlInjection",WCF_DIR."lib/system/security/plugins/sqlInjection/sqlInjection.class.php","sqlInjection");
			//$this->addResource("xss",WCF_DIR."lib/system/security/plugins/xss/xss.class.php","XSS");
			
			$this->fireActions();
		}
	}
	
	/**
	 * Loads config of plugins
	 *
	 * @param string $plugin
	 */
	protected function loadConfigFile($plugin) {
		if(!file_exists(WCF_DIR.'lib/system/security/plugins/'.$plugin.'/config.inc.php')) {
			//try to rewrite Config File
			require_once(WCF_DIR."lib/system/security/plugins/system/SecurityConfigWriter.class.php");
				$s = new SecurityConfigWriter($plugin);
				
			//couldn't rewrite Config File
			if(!file_exists(WCF_DIR.'lib/system/security/plugins/'.$plugin.'/config.inc.php')) {
				throw new SystemException("Couldn't find config at ".WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php'.");
			}
		}
		
		require(WCF_DIR.'lib/system/security/plugins/'.$plugin.'/config.inc.php');
				
		if(isset($activePlugin)) {
			$this->securityConfig[$plugin] = $activePlugin;
		} else {
			throw new SystemException("configfile of '".$plugin."' is not valid!");
		}
		
		if(isset($config) AND count($config) > 0) {
			foreach($config as $key=>$value) {
				if(!isset($this->securityConfig[$key])) {
					$this->securityConfig[$key] = $value;
				} 
			}
		}
		
		if(isset($exceptions) AND count($exceptions) > 0) {
			$this->fileExceptions($plugin,$exceptions);
		}
		
		// assign TemplateVars
		WCF::getTPL()->assign(array(
			'securityConfig' => $this->securityConfig
		));	
	}
	
	protected function fileExceptions($plugin,$exceptions) {
		
		$page = $this->getPage();
		
		if(!empty($page)) {
			if(isset($exceptions[$page])) {
				$this->securityConfig[$plugin] = $exceptions[$page];
			}
		}
	}
	
	public function getPage() {
		$requestHandler = RequestHandler::getActiveRequest();
			if(!empty($requestHandler->page)) {
				return $requestHandler->page;
			} elseif(!empty($requestHandler->form)) {
				return $requestHandler->form;
			} elseif(!empty($requestHandler->action)) {
				return $requestHandler->action;
			}
		
		return '';
	}
	
	/**
	 * Registers a new securty resource.
	 * 
	 * @param	string		$plugin		name of this resource
	 * @param	string		$classFile
	 */
	protected function addResource($plugin, $classFile, $className) {
		if(!isset($this->securityResources[$plugin])) {
		
			$this->loadConfigFile($plugin);

			if(!isset($this->securityConfig[$plugin])) {
				throw new SystemException("Couldn't find config var \$securityConfig['".$plugin."'].");
			} else {
				if($this->securityConfig[$plugin] == 1) {
					$this->securityResources[$plugin] = array("path"=>$classFile,"className"=>$className,"executed"=>0);
				}
			}
		} 
	}
	
	protected function loadActions() {
		if(count($this->securityResources) > 0) {
			foreach($this->securityResources as $plugin => $resource) {
				if (!file_exists($resource['path'])) {
					throw new SystemException("Unable to find class file '".$resource['path']."'");
				}
				
				require_once($resource['path']);
				
				if (!class_exists($resource['className'])) {
					throw new SystemException("Unable to find class '".$resource['className']."'");
				}
				
				$this->objects[$plugin] = new $resource['className'];
			}
						
		} else {
		//	throw new SystemException("Unable to find any security actions.");
		}
	}
	
	protected function fireActions() {
		
		if($this->activeSystem() == 1) {
			$this->loadActions();
			if(count($this->objects) > 0) {
				foreach($this->objects as $plugin => $action) {
					if($this->shutdown != 1 AND $this->securityResources[$plugin]['executed'] != 1) {
						$this->securityResources[$plugin]['executed'] = 1;
						$cmd = $action->execute($this,$plugin);
						
						//commands of plugin
						if(isset($cmd) AND !empty($cmd)) {
							switch($cmd) {
								case 'deactivate': $this->deactivateSystem($plugin); break;
							}
						}
					}
				}
			}
		}
	}
	
	/**
	 * @return boolean
	 */
	protected function activeSystem() {
		if(file_exists($this->securityConfig['systemFile'])) {
			return 1;
		} 
	}
	
	/**
	* @todo generate Error message and log.
	* @param $type (string): blacklist [done], honeypot [done], access [done], flood (limit,expire) [done], xss (data,path,secure)
	*/
	public function accessDenied($type,$additionals) {	
		
		if(!defined("SECURITY_BLOCKTYPE")) define("SECURITY_BLOCKTYPE",$type);
		
		//captcha
		if(isset($_REQUEST['page']) AND $_REQUEST['page'] == "Captcha") {
			return false;
		}
		
		//exceptions (unlockPage)
		if((isset($_REQUEST['form']) AND $_REQUEST['form'] == "SecurityUnlock")) {
			if(isset($_REQUEST['action']) AND in_array($_REQUEST['action'],array("honeypot","access","activate","mail"))) {
				return false;
			}
		}
		
			
		//echo "<pre>SecurityHandler::accessDenied()<br /><br /> <u>@param</u> \$type string ".$type."<br /> <u>@param</u> \$additionals ";
		//	print_r($additionals);
		//echo"</pre>";
		
		if(SECURITY_BLOCKTYPE == "blacklist") {
			if(!empty($this->securityConfig['blacklistForward'])) {
				header("Location: ".$this->securityConfig['blacklistForward']."");
				exit();
			}
		}

		switch(SECURITY_BLOCKTYPE) {
			case "blacklist": $error=WCF::getLanguage()->get("wcf.security.error.blacklist"); break;
			case "honeypot": $error=WCF::getLanguage()->get("wcf.security.error.honeypot"); break;
			case "flood": $error=WCF::getLanguage()->get("wcf.security.error.flood",array("\$limit"=>$additionals['limit'],"\$expire"=>date("d.m.Y, H:i",$additionals['expire']))); break;
			case "access": $error=WCF::getLanguage()->get("wcf.security.error.access"); break;
			case "sqlInjection": $error=WCF::getLanguage()->get("wcf.security.error.sqlInjection",array("\$pathVar"=>"\$".implode("::",$additionals['path']))); break;
			case "xss": $error=WCF::getLanguage()->get("wcf.security.error.xss",array("\$pathVar"=>"\$".implode("::",$additionals['path']))); break;
		}
		
		$this->attackJournal(SECURITY_BLOCKTYPE);
		
		WCF::getTPL()->assign(array(
			'error' => $error,
			'additionals' => $additionals
		));
		
		WCF::getTPL()->display('securityError');
		exit;
	}
	
	/**
	 * saves Information about attack
	 *
	 * @param String $type
	 */
	private function attackJournal($type="unknown") {
		
		if(!in_array($type,array('xss', 'flood', 'spyware', 'sqlInjection', 'access', 'honeypot','blacklist'))) {
			$type = "unknown";
		}
		
		$journal = $this->generateJournal($type);
		
		$journalData = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_attacks` WHERE `time` > '".(TIME_NOW-3600)."' AND `ipAddress` = '".$_SERVER['REMOTE_ADDR']."' AND `host`='".addslashes(gethostbyaddr($_SERVER['REMOTE_ADDR']))."'");
		if($journalData['id'] == 0) {
			WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_attacks` (`id`,`type`,`time`,`ipAddress`,`host`,`browser`,`journal`,`new`,`hidden`) VALUES (NULL , '".addslashes($type)."', '".TIME_NOW."', '".$_SERVER['REMOTE_ADDR']."', '".addslashes(gethostbyaddr($_SERVER['REMOTE_ADDR']))."', '".addslashes($_SERVER['HTTP_USER_AGENT'])."', '".addslashes($journal)."', '1', '0');");
		} else {			
			if(in_array($type,array('xss','sqlInjection','access'))) {
				$journal = explode("\n",$journal);
					$journal[0] = "";
					$journal[1] = "";
				
				//new entry for journal
				WCF::getDB()->sendQuery("UPDATE `wcf".WCF_N."_security_attacks` SET `journal`='".addslashes($journalData['journal'].implode("\n",$journal))."' WHERE `id`='".$journalData['id']."'");
			}
		}
		
	}
	
	/**
	 * generate AttackJournal
	 *
	 * @return String $journal
	 */
	private function generateJournal() {
		
		$journal = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		$journal .= "<!DOCTYPE attackJournal SYSTEM \"DTD/attackJournal.dtd\">\n";
		$journal .= "<attackJournal>\n";
			$journal .= "\t<system>\n";
				$journal .= "\t\t<wcfVersion><![CDATA[".WCF_VERSION."]]></wcfVersion>\n";
				$journal .= "\t\t<package><![CDATA[".PACKAGE_NAME."]]></package>\n";
				$journal .= "\t\t<packageID><![CDATA[".PACKAGE_ID."]]></packageID>\n";
				$journal .= "\t\t<system><![CDATA[".SECURITY_PRODUCT."]]></system>\n";
				$journal .= "\t\t<version><![CDATA[".SECURITY_VERSION."]]></version>\n";
				$journal .= "\t\t<adminMailAddress><![CDATA[".MAIL_ADMIN_ADDRESS."]]></adminMailAddress>\n";
			$journal .= "\t</system>\n";
			
			$journal .= "\t<attackInformation>\n";
				$journal .= "\t\t<time><![CDATA[".TIME_NOW."]]></time>\n";
				$journal .= "\t\t<date><![CDATA[".date("r",TIME_NOW)."]]></date>\n";
				$journal .= "\t\t<attackType><![CDATA[".SECURITY_BLOCKTYPE."]]></attackType>\n";
			$journal .= "\t</attackInformation>\n";
			
			$journal .= "\t<user>\n";
				$journal .= "\t\t<userID><![CDATA[".WCF::getUser()->userID."]]></userID>\n";
				$journal .= "\t\t<username><![CDATA[".WCF::getUser()->username."]]></username>\n";
				$journal .= "\t\t<email><![CDATA[".WCF::getUser()->email."]]></email>\n";
			$journal .= "\t</user>\n";
			
			$journal .= "\t<userConnection>\n";
				$journal .= "\t\t<ipAddress><![CDATA[".$_SERVER['REMOTE_ADDR']."]]></ipAddress>\n";
				$journal .= "\t\t<remotePort><![CDATA[".$_SERVER['REMOTE_PORT']."]]></remotePort>\n";
				$journal .= "\t\t<host><![CDATA[".gethostbyaddr($_SERVER['REMOTE_ADDR'])."]]></host>\n";
				$journal .= "\t\t<browser><![CDATA[".$_SERVER['HTTP_USER_AGENT']."]]></browser>\n";
			$journal .= "\t</userConnection>\n";
			
			$journal .= "\t<serverInformation>\n";
				foreach($_SERVER as $key=>$value) {
					if(!self::isProtectedValue($key)) {
						$journal .= "\t\t<".$key."><![CDATA[".$value."]]></".$key.">\n";
					} else {
						$journal .= "\t\t<".$key."><![CDATA[.protectedValue]]></".$key.">\n";
					}
				}
			$journal .= "\t</serverInformation>\n";
			
			if(count($_POST) > 0) {
				$journal .= "\t<userInputPost>\n";
					foreach($_POST as $key=>$value) {
						if(!self::isProtectedValue($key)) {
							$journal .= "\t\t<".$key."><![CDATA[".$value."]]></".$key.">\n";
						} else {
							$journal .= "\t\t<".$key."><![CDATA[.protectedValue]]></".$key.">\n";
						}
					}
				$journal .= "\t</userInputPost>\n";
			}
			
			if(count($_GET) > 0) {
				$journal .= "\t<userInputGet>\n";
					foreach($_GET as $key=>$value) {
						if(!self::isProtectedValue($key)) {
							$journal .= "\t\t<".$key."><![CDATA[".$value."]]></".$key.">\n";
						} else {
							$journal .= "\t\t<".$key."><![CDATA[.protectedValue]]></".$key.">\n";
						}
					}
				$journal .= "\t</userInputGet>\n";
			}
		$journal .= "</attackJournal>";
		
		
		return $journal;
	}
	
	/**
	 * checks if $key is an protected input (like passwords)
	 *
	 * @param String $key
	 * @return Boolean
	 */
	public static function isProtectedValue($key) {
		
		$protected = array("PHP_AUTH_PW","HTTP_COOKIE","password","passwort","pass","pw","kennwort");
		
		if(in_array($key,$protected)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	* deaktivates system
	*/
	private function deactivateSystem($plugin) {
		//only allowed command from special plugins
		if(in_array($plugin,array("blacklist"))) {
			$this->shutdown = 1;
		}
	}
	
	public function checkReferer() {
		if(isset($_SERVER['HTTP_REFERER']) AND !ereg($_SERVER['SERVER_NAME'],$_SERVER['HTTP_REFERER']) AND !empty($_SERVER['HTTP_REFERER'])) { 
			return 1; 
		} 
		
		return 0; 
	}
	
	public function __clone() {
		throw new SystemException("AccessDenied: function clone() is for the SecurityHandler not allowed!");
	}
	
}

?>