<?php
//define('SECURITY_BENCHMARK',true);

//constants
if(!defined('SECURITY_BENCHMARK')) define('SECURITY_BENCHMARK',false);

//wcf imports
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');
require_once(WCF_DIR.'lib/system/security/SecurityHandler.class.php');


//benchmark libary
if(SECURITY_BENCHMARK == true) {
	require_once(WCF_DIR.'lib/system/benchmark/Benchmark.class.php');
}


/**
 * @author	Peter Frhwirt
 * @package	com.security.premium
 */
class SecurityListener implements EventListener {
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		
		if(SECURITY_BENCHMARK == true) {
			$b = new Benchmark();
				$b->start('SecuritySystem Performance',1);
		}
		
		$securityHandler = new SecurityHandler();
			$securityHandler->systemCore();
			$securityHandler->extendedSystem();
			
		if(SECURITY_BENCHMARK == true) {
			$b->stop();
			WCF::getTPL()->assign('securityBenchmarkResults',$b->getResult());
		}
	}
}


?>