<?php
require_once(WCF_DIR.'lib/data/cronjobs/Cronjob.class.php');

/**
 * @author	Peter Frhwirt
 * @package de.wbb-security.premium
 */
class SecurityServicingCronjob implements Cronjob {
	
	protected $cache = array();
	
	/**
	 * @see Cronjob::execute()
	 */
	public function execute($data) {
		
		if(file_exists(WCF_DIR."lib/system/security/cache/cache.system.php")) {
			
			$activePlugin = 1;
			require(WCF_DIR."lib/system/security/plugins/system/config.inc.php");
			
			if($activePlugin == 1) {
				//system check
				$this->systemCheck();
				
				//system cleanup (filesystem)
				$this->systemCleanUp();
				
				//system cleanup (database)
				$this->databaseCleanUp();
			}
		}
	}
	
	private function systemCheck() {

	}
	
	private function databaseCleanUp() {

		//old blacklist entries
		WCF::getDB()->sendQuery("DELETE FROM `wcf".WCF_N."_security_blacklist` WHERE `validity` > '0' AND `validity` < '".(TIME_NOW-86400)."'");
		
		//delete flood date
		WCF::getDB()->sendQuery("TRUNCATE `wcf".WCF_N."_security_flood`");
	}
	
	private function systemCleanUp() {
	
	}
}
?>