<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityLicensePage extends AbstractPage {
	public $templateName = 'securityLicense';
	public $activeMenuItem = 'wcf.acp.menu.link.security.system.license';
	public $neededPermissions = 'admin.security.canViewLicense';
	
	protected $system = array();
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		
		$this->system['installID'] = file_get_contents(WCF_DIR."lib/system/security/storage/system/installID.inc.php");
		
		// enable menu item
		if (!empty($this->activeMenuItem)) WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		
		// check permission
		if (!empty($this->neededPermissions)) WCF::getUser()->checkPermission($this->neededPermissions);
		
		
		// show page
		parent::show();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'system' => $this->system,
			'license' => str_replace("\n","<br />",file_get_contents(WCF_DIR.'lib/system/security/storage/system/licenseFile.inc.php'))
		));
	}
}
?>