<?php
require_once(WCF_DIR.'lib/page/SortablePage.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityBlacklistPage extends SortablePage {
	public $templateName = 'securityBlacklist';
	public $activeMenuItem = 'wcf.acp.menu.link.security.protection.blacklist.list';
	public $neededPermissions = 'admin.security.canViewBlacklist';
	
	public $itemsPerPage = 20;
	
	protected $blacklist = array();
	
	
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if(isset($_REQUEST['sortField'])) { $this->sortField = $_REQUEST['sortField']; } else { $this->sortField = "id"; }
		if(isset($_REQUEST['sortOrder'])) { $this->sortOrder = $_REQUEST['sortOrder']; } else { $this->sortOrder = "ASC"; }
		
	}
	
	/**
	 * @see SortablePage::validateSortField()
	 */
	public function validateSortField() {
		parent::validateSortField();
		
		switch ($this->sortField) {
			case 'id': $this->sortField = 'id'; break;
			case 'object': $this->sortField = 'object'; break;
			case 'value': $this->sortField = 'value'; break;
			case 'validity': $this->sortField = 'validity'; break;
			default: $this->sortField = 'id';
		}
	}
	
	

	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		$markedItems = WCF::getSession()->getVar('markedBlacklistItems');	
			if(!is_array($markedItems)) $markedItems = array();

		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_blacklist`  ORDER BY `".$this->sortField."` ".$this->sortOrder."  LIMIT ".$this->itemsPerPage." OFFSET ".($this->pageNo - 1) * $this->itemsPerPage);
		while($row = WCF::getDB()->fetchArray($result)) {
			if(in_array($row['id'],$markedItems)) $row['isMarked'] = 1;
				else $row['isMarked'] = 0;

			$this->blacklist[$row['id']] = $row;
		}
		
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$markedItems = WCF::getSession()->getVar('markedBlacklistItems');	
		if(!is_array($markedItems)) {
			$markedItems = 0;
		} else {
			$markedItems = count($markedItems);
		}
		
		WCF::getTPL()->assign(array(
			'blacklist' => $this->blacklist,
			'fields' => array("checkbox","id","object","value","validity"),
			'markedItems' => $markedItems
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		if(!empty($this->activeMenuItem)) {
			WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		}
		
		// check permission
		if(!empty($this->neededPermissions)) {
			WCF::getUser()->checkPermission($this->neededPermissions);
		}
		
		parent::show();
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();

		$row = WCF::getDB()->getFirstRow("SELECT count(*) as `count` FROM `wcf".WCF_N."_security_blacklist`");
		WCF::getTPL()->assign(array('count' => $row['count']));
		return $row['count'];
	}
}
?>