<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityAttacksPage extends AbstractPage {
	public $templateName = 'securityAttacks';
	public $activeMenuItem = 'wcf.acp.menu.link.security.protection.attacks';
	public $neededPermissions = 'admin.security.canViewAttacks';
	
	protected $attacks = array("xss" => array(),"sqlInjection" => array(), "access" => array(), "blacklist" => array() );
	

	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		$markedJournals = WCF::getSession()->getVar('markedAttacks');	
		if(!is_array($markedJournals)) $markedJournals = array();
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_attacks` WHERE `hidden` = '0' ORDER BY `id` ASC");
		while($row = WCF::getDB()->fetchArray($result)) {
			if(in_array($row['id'],$markedJournals)) {
				$row['isMarked'] = 1;
			} else {
				$row['isMarked'] = 0;
			}
			
			if(isset($this->attacks[$row['type']])) {
				$this->attacks[$row['type']][] = $row;
			}
		}
	}
	
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		
		// enable menu item
		if (!empty($this->activeMenuItem)) WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		
		// check permission
		if (!empty($this->neededPermissions)) WCF::getUser()->checkPermission($this->neededPermissions);
		
		
		// show page
		parent::show();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$markedJournals = WCF::getSession()->getVar('markedAttacks');	
		if(!is_array($markedJournals)) {
			$markedJournals = 0;
		} else {
			$markedJournals = count($markedJournals);
		}
			
		
		WCF::getTPL()->assign(array(
			'attacks' => $this->attacks,
			'markedJournals' => $markedJournals
		));
	}
}
?>