<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');
require_once(WCF_DIR.'lib/system/session/UserSession.class.php');
require_once(WCF_DIR.'lib/system/auth/UserAuth.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityStopForm extends ACPForm {
	public $templateName = 'securityStop';
	public $activeMenuItem = 'wcf.acp.menu.link.security.config.system';
	public $neededPermissions = 'admin.security.canEditConfig';
	
	protected $input = array();

	/**
	 * @see Page::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		foreach(array("username","password") as $key) {
			if(isset($_POST[$key])) $this->input[$key] = $_POST[$key];
				else $this->input[$key] = "";
		}
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();

		if(empty($this->input['username'])) {
			throw new UserInputException('username');
		}

		if(empty($this->input['password'])) {
			throw new UserInputException('password');
		}

		$user = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_user` WHERE `username`='".addslashes($this->input['username'])."'");
		if($user['userID'] == 0) {
			throw new UserInputException('username','notFound');
		}
		
		$session = new UserSession($user['userID'], $user);
		if($session->getPermission('admin.security.canEditConfig') == false) {
			throw new UserInputException('username','permission');
		}
		
		if($user['password'] != StringUtil::getDoubleSaltedHash($this->input['password'],$user['salt'])) {
			throw new UserInputException('password','notValid');
		}

	}
	
	/**
	 * @see Page:readData();
	 */
	public function readData() {
		parent::readData();
		
		
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		//deactivate system
		@unlink(WCF_DIR.'lib/system/security/cache/cache.system.php');
		
		// show success.
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		parent::show();
		
		//system is deactivated
	/*	if(!file_exists(WCF_DIR.'lib/system/security/cache/cache.system.php')) {
			header("Location: index.php?form=SecurityConfig&packageID=".PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
			exit;
		}	*/
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		if(!isset($this->input['username'])) {
			$this->input['username'] = WCF::getUser()->username;
		}
		
		WCF::getTPL()->assign(array(
			'input' => $this->input,
		));
	}
}
?>