/**
 * @author	Peter Fruehwirt
 */
function SecurityAttackListEdit(data, count, additionalOptions) {
	this.data = data;
	this.count = count;
	this.additionalOptions = additionalOptions;
	
	/**
	 * Saves the marked status.
	 */
	this.saveMarkedStatus = function(data) {
		var ajaxRequest = new AjaxRequest();
		ajaxRequest.openPost('index.php?page=SecurityAttacksAction'+SID_ARG_2ND, data);
	}
	
	/**
	 * Returns a list of the edit options for the edit menu.
	 */
	this.getEditOptions = function(id) {
		return new Array();
	}
	
	/**
	 * Returns a list of the edit options for the edit marked menu.
	 */
	this.getEditMarkedOptions = function() {
		var options = new Array();
		var i = 0;
		
		options[i] = new Object();
		options[i]['function'] = 'securityAttackListEdit.removeMarked();';
		options[i]['text'] = language['wcf.global.button.delete'];
		i++;
		
		
		options[i] = new Object();
		options[i]['function'] = 'securityAttackListEdit.downloadMarked();';
		options[i]['text'] = language['wcf.acp.security.attacks.downloadMarked'];
		options[i]['className'] = 'bottomSeparator';
		i++;
	/*	
		options[i] = new Object();
		options[i]['function'] = 'securityAttackListEdit.exportMailAddress();';
		options[i]['text'] = language['wcf.acp.user.button.exportMail'];
		i++; */

		// additional options
		for (var j = 0; j < this.additionalOptions.length; j++) {
			options[i] = new Object();
			options[i]['function'] = this.additionalOptions[j]['function'];
			options[i]['text'] = this.additionalOptions[j]['text'];
			if (this.additionalOptions[j]['className']) options[i]['className'] = this.additionalOptions[j]['className'];
			i++;
		}
		
		// unmark all
		options[i] = new Object();
		options[i]['function'] = 'securityAttackListEdit.unmarkAll();';
		options[i]['text'] = language['wcf.global.button.unmark'];
		i++;
		
		return options;
	}
	
	/**
	 * Ummarked all marked pms.
	 */
	this.unmarkAll = function() {
		var ajaxRequest = new AjaxRequest();
		ajaxRequest.openGet('index.php?page=SecurityAttacksAction&action=unmarkAll'+SID_ARG_2ND);
		
		this.removeMarks();
	}
	

	/**
	 * Deletes the marked messages.
	 */
	this.removeMarked = function() {
		if (confirm(language['wcf.acp.security.attacks.deleteMarked.sure'])) {
			document.location.href = fixURL('index.php?page=SecurityAttacksAction&action=deleteMarked'+SID_ARG_2ND);
		}
	}
	
	this.removeMarks = function() {
		// checkboxes
		this.count = 0;
		for (var id in this.data) {
			this.data[id]['isMarked'] = 0;
			var checkbox = document.getElementById('attackMark' + id);
			if (checkbox) {
				checkbox.checked = false;
			}
			
			this.showStatus(id);
		}
		
		// mark all checkbox
		this.parentObject.checkMarkAll(false);
		
		// edit marked menu
		this.parentObject.showMarked();
	}
	
	this.downloadMarked = function() {
		this.removeMarks();
		document.location.href = fixURL('index.php?page=SecurityAttacksAction&action=downloadMarked'+SID_ARG_2ND);
	}
	
	/**
	 * Returns the title for the marked message box.
	 */
	this.getMarkedTitle = function() {
		return eval(language['wcf.acp.security.attacks.markedAttacks']);
	}
	
	/**
	 * Shows the status of a message.
	 */
	this.showStatus = function(id) {
		// get row
		var row = document.getElementById('attackRow'+id);
		
		// update css class
		if (row) {
			// get class
			var className = row.className;
		
			// original className
			if (this.data[id]['class'] != className) {
				className = this.data[id]['class'];
			}
			
			// marked
			if (this.data[id]['isMarked']) {
				// add marked class
				className += ' marked';
			}
			
			row.className = className;
		}
	}
	
	this.parentObject = new InlineListEdit('attack', this);
}