{include file="documentHeader"}
<head>
	<title>{lang}wcf.security{/lang} - {PAGE_TITLE}</title>
	{include file='headInclude' sandbox=false}
</head>
<body>
{include file='header' sandbox=false}


<div id="main">
		

	

	{if SECURITY_BLOCKTYPE == "mail"}
	
		<div class="border content">
			<div class="container-1">
				<ul>
					{foreach from=$fireback item=mail}
						<li><a href="mailto:{$mail}">{$mail}</a></li>
					{/foreach}
				</ul>
				
				<div align="center">
					{if $page > 0}<a href="index.php?form=SecurityUnlock&amp;action=mail&amp;pageNo={$page-1}{@SID_ARG_2ND}">&laquo;</a> | {/if}
					<a href="index.php?form=SecurityUnlock&amp;action=mail&amp;pageNo={$page+1}{@SID_ARG_2ND}">&raquo;</a>
				</div>
			</div>
		</div>
	
	{else} 
	
		<div class="mainHeadline">
			<img src="{@RELATIVE_WCF_DIR}icon/securityL.png" alt="" />
			<div class="headlineContainer">
				<h2>{lang}wcf.security.error.unlock{/lang}</h2>
			</div>
		</div>
		
		
		{if $errorField}
			<p class="error">{lang}wcf.global.form.error{/lang}</p>
		{/if}
	
		<form method="post" action="index.php?form=SecurityUnlock&amp;action={SECURITY_BLOCKTYPE}">
			<div class="border content">
				<div class="container-1">
				
					<input type="hidden" name="action" value="{SECURITY_BLOCKTYPE}" />
				
					{if SECURITY_BLOCKTYPE == "access"}
						
						<div class="formElement{if $errorField == 'email'} formError{/if}">
							<div class="formFieldLabel">
								<label for="mail">{lang}wcf.user.email{/lang}</label>
							</div>
							<div class="formField">
								<input type="text" class="inputText" name="mail" value="{$input['mail']}" id="mail" />
							
								{if $errorField == 'email'}
									<p class="innerError">
										{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
										{if $errorType == 'notValid'}{lang}wcf.user.error.email.notValid{/lang}{/if}
										{if $errorType == 'error'}{lang}wcf.security.error.unlock.mail.error{/lang}{/if}
									</p>
								{/if}
							</div>
						</div>
						
					{/if}
					
				
					{if SECURITY_BLOCKTYPE == "activate"}
					
						<p>{lang}wcf.security.error.unlock.activationCode.desc{/lang}</p><br />
					
						<div class="formElement">
							<div class="formFieldLabel">
								<label for="mail">{lang}wcf.user.email{/lang}</label>
							</div>
							<div class="formField">
								{$this->getUser()->email}
							</div>
						</div>
						
						<div class="formElement{if $errorField == 'activationCode'} formError{/if}">
							<div class="formFieldLabel">
								<label for="activationCode">{lang}wcf.security.error.unlock.activationCode{/lang}</label>
							</div>
							<div class="formField">
								<input type="text" class="inputText" name="activationCode" value="{$input['activationCode']}" id="activationCode" />
							
								{if $errorField == 'activationCode'}
									<p class="innerError">
										{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
										{if $errorType == 'notValid'}{lang}wcf.security.error.unlock.activationCode.notValid{/lang}{/if}
										{if $errorType == 'expired'}{lang}wcf.security.error.unlock.activationCode.expired{/lang}{/if}
									</p>
								{/if}
							</div>
						</div>
					
					{/if}
					
					{if SECURITY_BLOCKTYPE == "honeypot" || SECURITY_BLOCKTYPE == "access"}
						{include file='captcha'}
					{/if}
				
				
					<div class="formSubmit">
						<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
						<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" />
					</div>
				
					{@SID_INPUT_TAG}
			
				</div>
			</div>
		</form>
		
	{/if}
	

</div>


{include file='footer' sandbox=false}
</body>
</html>