<?xml version="1.0" encoding="{@CHARSET}"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="{lang}wcf.global.pageDirection{/lang}" xml:lang="{@LANGUAGE_CODE}">
	<head>
		<title>{lang}wcf.global.pageTitle{/lang} - {lang}wcf.acp{/lang}</title>
		<meta http-equiv="Content-Type" content="text/html; charset={@CHARSET}" />

		<style type="text/css">
			@import url("{@RELATIVE_WCF_DIR}acp/style/securityLogin.css");
		</style>		
	</head>
<body>

<div class="header">
	<img src="{@RELATIVE_WCF_DIR}images/security/securityLoginLogo.png" alt="" />
</div>


<div class="page" align="center">

	<div class="content">
		{if $errorField == 'token'}
			{if $errorType == 'notValid'}<div class="error" style="margin-bottom:10px;">{lang}wcf.security.login.error.token{/lang}</div>{/if}
		{else}
			{if $standardLogin == 1}<div class="warning" style="margin-bottom:10px;">{lang}wcf.security.login.standard{/lang}</div>{/if}
		{/if}
		<form method="post" action="index.php?form=Login">
			<fieldset>
				<legend>{lang}wcf.security.login{/lang}</legend>
				
				<div class="inner">
					<div{if $errorField == 'username'} class="errorField"{/if}>
						<label for="username">{lang}wcf.user.username{/lang}</label>
						<input type="text" class="inputText" id="username" name="username" value="{$username}" />
						{if $errorField == 'username'}
							<p>
								<img src="{@RELATIVE_WCF_DIR}icon/errorS.png" alt="" />
								{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
								{if $errorType == 'notFound'}{lang}wcf.user.error.username.notFound{/lang}{/if}
							</p>
						{/if}
					</div>
		
					
					<div{if $errorField == 'password'} class="errorField"{/if}>
						<label for="password">{lang}wcf.user.password{/lang}</label>
						<input type="password" class="inputText" id="password" name="password" value="" />
						{if $errorField == 'password'}
							<p>
								<img src="{@RELATIVE_WCF_DIR}icon/errorS.png" alt="" />
								{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
								{if $errorType == 'false'}{lang}wcf.user.error.password.false{/lang}{/if}
							</p>
						{/if}
					</div>

				</div>
			</fieldset>
			
			<div class="nextButton">
				<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
				<input type="hidden" name="packageID" value="{@PACKAGE_ID}" />
				<input type="hidden" name="url" value="{$url}" />
				<input type="hidden" name="token" value="{$token}" />
				<input type="hidden" name="event" value="SecurityLogin" />
		 		{@SID_INPUT_TAG}
			</div>
		</form>
	
	</div>
</div>


{if SECURITY_COPYRIGHT == 1}
	<div class="copyright"><a href="http://www.wbb-security.de/">{lang}wcf.security.copyright{/lang}</a></div>
{/if}


</body>
</html>