<?php
/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008
 */
final class SecurityConfigWriter {

	private $plugin = "";
	
	private $activePlugin = 1;
	private $configData = array();
	
	
	private $data = array();
	private $config = array();
	private $constants = array();
	private $exceptions = array();
	
	/**
	 * creates new SecurityConfigWriter
	 *
	 * @param String $plugin
	 */
	public function __construct($plugin="") {
		$this->plugin = $plugin;
		
		//reload one plugin
		if(!empty($this->plugin)) {
			if($this->getPluginData()) {
				$this->writeConfig();
			}
		} else {
			//update all plugins
			foreach(scandir(WCF_DIR."lib/system/security/plugins/") as $plugin) {
				if($plugin != "." AND $plugin != ".." AND substr($plugin,-4,4) != ".php") {
					$pluginWriter = new SecurityConfigWriter($plugin);
				}
			}
		}
	}
 
	/**
	 * loads all data of an existing plugin
	 */
	private function getPluginData() {
		$this->data = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_plugins` WHERE `plugin`='".addslashes($this->plugin)."'");
		if($this->data['id'] == 0) {
			//throw new SystemException("Couldn't find plugin \"".$this->plugin."\"!");
			
			return false;
		}
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_plugins_config` WHERE `plugin`='".addslashes($this->plugin)."'");
		while($row = WCF::getDB()->fetchArray($result)) {
			$this->config[] = $row;
		}
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_plugins_constants` WHERE `plugin`='".addslashes($this->plugin)."'");
		while($row = WCF::getDB()->fetchArray($result)) {
			$this->constants[] = $row;
		}
		if(file_exists(WCF_DIR."lib/system/security/plugins/".$this->plugin."/config.inc.php")) {
			require(WCF_DIR."lib/system/security/plugins/".$this->plugin."/config.inc.php");
			
			//exceptions
			if(isset($exceptions)) {
				$this->exceptions = $exceptions;
			}
			
			//existing Config
			if(isset($config)) {
				$this->configData = $config;
			}
			
			//active plugin
			if(isset($activePlugin)) {
				$this->activePlugin = $activePlugin;
			}
		} else {
			$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_plugins_exceptions` WHERE `plugin`='".addslashes($this->plugin)."'");
			while($row = WCF::getDB()->fetchArray($result)) {
				$this->exceptions[$row['file']] = $row['value'];
			}
		}
		
		return true;
	}
	
	/**
	 * writes config file of plugin
	 */
	private function writeConfig() {
		$file = "<?php\n";
		$file .= "/**\n";
		$file .= " * generated at\t".date("r",TIME_NOW)."";
		$file .= " * \n";
		$file .= " * @package\t\t".$this->data['package']."\n";
		$file .= " * @author\t\t".utf8_decode($this->data['author'])."\n";
		$file .= " */\n\n";

		$file .= "/** activate plugin **/\n";
		$file .= "	\$activePlugin = ".intval($this->activePlugin).";\n\n";
		
		$file .= "/** package informations **/\n";
		$file .= "\t\$package = array();\n";
		$file .= "\t\t\$package['author'] = \"".addslashes($this->data['author'])."\";\n";
		$file .= "\t\t\$package['authorURL'] = \"".addslashes($this->data['authorURL'])."\";\n";
		$file .= "\t\t\$package['version'] = \"".addslashes($this->data['version'])."\";\n";
		$file .= "\t\t\$package['license'] = \"".addslashes($this->data['license'])."\";\n";
		$file .= "\t\t\$package['category'] = \"".addslashes($this->data['category'])."\";\n\n";

		$file .= "/** special config **/\n";
		$file .= "\t\$config = array();\n";
		if(count($this->config) > 0) {
			foreach($this->config as $item) {
				if(isset($this->configData[$item['configVar']])) $value = $this->configData[$item['configVar']];
					else $value = $item['default'];
				
				$file .= "\t\t\$config['".addslashes($item['configVar'])."'] = \"".addslashes($value)."\";\n";
			}
		}
		
		$file .= "\n/** special configfields **/\n";
		$file .= "\t\$fields = array();\n";
		if(count($this->config) > 0) {
			foreach($this->config as $item) {
				$file .= "\t\t\$fields['".addslashes($item['configVar'])."'] = array(\"type\"=>\"".addslashes($item['type'])."\",\"min\"=>\"".addslashes($item['min'])."\",\"max\"=>\"".addslashes($item['max'])."\",\"valid\"=>\"".addslashes($item['valid'])."\",\"required\"=>".intval($item['required']).");\n";
			}
		}

		$file .= "\n/** file exceptions **/\n";
		$file .= "\t\$exceptions = array();\n";
		if(count($this->exceptions) > 0) {
			foreach($this->exceptions as $key=>$value) {
				$file .= "\t\t\$exceptions['".addslashes($key)."'] = ".intval($value).";\n";
			}
		}
		
		$file .= "\n/** constants **/\n";
		if(count($this->constants) > 0) {
			foreach($this->constants as $item) {
				switch($item['type']) {
					case "text": $file .= "	if(!defined('".addslashes(strtoupper($item['const']))."')) define('".addslashes(strtoupper($item['const']))."',\"".addslashes($item['value'])."'\");\n"; break;
					case "configVar": $file .= "	if(!defined('".addslashes(strtoupper($item['const']))."')) define('".addslashes(strtoupper($item['const']))."',\$config['".addslashes($item['value'])."']);\n"; break;
				}
			}
		}
		
		$file .= "\n?>";
		
		$fp = fopen(WCF_DIR."lib/system/security/plugins/".$this->plugin."/config.inc.php","w");
			@fwrite($fp,$file);
			@fclose($fp);

		@chmod(WCF_DIR."lib/system/security/plugins/".$this->plugin."/config.inc.php",0777);
	}
}

?>
