<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityAccessAddForm extends ACPForm {
	public $templateName = 'securityAccessAdd';
	public $activeMenuItem = 'wcf.acp.menu.link.security.config.access.add';
	public $neededPermissions = 'admin.security.canEditAccess';
	public $input = array("username"=>"","password"=>"","confirmPassword"=>"");
	
	
	
	/**
	 * @see Page::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		foreach($this->input as $key=>$value) {
			if(isset($_POST[$key])) {
				$this->input[$key] = $_POST[$key];
			}
		}
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if(empty($this->input['username'])) {
			throw new UserInputException('username');
		}
		
		$user = WCF::getDB()->getFirstRow("SELECT `id` FROM `wcf".WCF_N."_security_accounts` WHERE `username`='".addslashes($this->input['username'])."'");
		if($user['id'] != 0) {
			throw new UserInputException('username', 'notUnique');
		}
		
		
		if(empty($this->input['password'])) {
			throw new UserInputException('password');
		}
		
		//password is equal with user password
		if(WCF::getUser()->password == StringUtil::getDoubleSaltedHash($this->input['password'],WCF::getUser()->getSalt())) {
			throw new UserInputException('password','equal');
		}
		
		if($this->input['password'] != $this->input['confirmPassword']) {
			throw new UserInputException('confirmPassword', 'notEqual');
		}
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		$checksum = md5(microtime().uniqid());
		WCF::getDB()->sendQuery("INSERT INTO `wcf1_security_accounts` (`id`,`username`,`password`,`checksum`,`ipAddress`,`host`,`accessErrors`) VALUES (NULL , '".addslashes($this->input['username'])."', '".md5($checksum.md5($this->input['password']))."', '".addslashes($checksum)."', '0.0.0.0', '', '0')");
		
		$this->input = array("username"=>"","password"=>"","confirmPassword"=>"");
		
		// show success.
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'input' => $this->input
		));
	}
}
?>