<?php
require_once(WCF_DIR.'lib/system/security/SecurityHandler.class.php');

/**
 * @author	Peter Frhwirt
 * @package	com.security.premium
 */
class Blacklist implements SecurityBuilder {
	
	var $security;
	var $blacklist = array();
	
	/**
	 * @see SecurityBuilder::execute()
	 */
	public function execute($securityObj,$plugin) {
		
		$this->security = $securityObj;
		
		$this->buildCache();
			return $this->handleList();
	}
	
	protected function buildCache() {

        WCF::getCache()->addResource('blacklist', WCF_DIR.'lib/system/security/cache/cache.blacklist.php',WCF_DIR.'lib/system/security/cache/builder/CacheBuilderBlacklist.class.php', 300, 600);

        $this->loadList();
	}
	
	protected function clearCache() {
		WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.blacklist.php');
	}
	
	protected function loadList() {
		$this->blacklist = WCF::getCache()->get('blacklist');
	}
	
	public function handleList() {
		if(count($this->blacklist) > 0) {
			foreach($this->blacklist as $item) {
				if($item['validity'] != "-1" AND $item['validity'] < time()) {
					$clearCache = 1;
				}
				
				if($this->compareUser($item['object'],$item['value'])) {
					switch($item['status']) {
						case "block": 
									$this->security->accessDenied("blacklist",array()); 
								break;
						case "flood": 
									if(WCF::getUser()->userID == 0) { 
										$this->security->accessDenied("flood",array("limit"=>$this->security->securityConfig['floodLimitGuest'],"expire"=>$item['validity'])); 
									} else {
										$this->security->accessDenied("flood",array("limit"=>$this->security->securityConfig['floodLimitUser'],"expire"=>$item['validity'])); 
									}
								break;
						case "ignore": 
									//$this->security->deactivateSystem(); 
									return 'deactivate';
								break;
					}
					continue;
				}
			}
		}
		
		
		if(isset($clearCache) AND $clearCache == 1) {
			$this->clearCache();
		}
	}
	
	public function compareUser($object,$value) {
				
		switch($object) {
			case "ip": if(@ereg(self::createParseObject($object,$value),$_SERVER['REMOTE_ADDR'])) { return 1; } else { return 0; } break;	
			case "browser": if(@ereg(self::createParseObject($object,$value),$_SERVER['HTTP_USER_AGENT'])) { return 1; } else { return 0; } break;	
			case "host": if(@ereg(self::createParseObject($object,$value),gethostbyaddr($_SERVER['REMOTE_ADDR']))) { return 1; } else { return 0; } break;
		}
	}
	
	public function createParseObject($object,$value,$wildcard="?") {
		
		switch($object) {
			case "ip": $value = str_replace($wildcard,"[0-9]{1,3}",$value); break;
			case "browser": $value = str_replace($wildcard,"(.*)",$value); break;
			case "host": $value = str_replace($wildcard,"(.*)",$value); break;
		}
		
		return $value;
	}
	
}


?>