<?php
require_once(WCF_DIR.'lib/form/CaptchaForm.class.php');

/**
 * @author	Peter Frhwirt
 * @package	com.security.premium
 */
class SecurityUnlockForm extends CaptchaForm {
	public $templateName = 'securityUnlock';	
	
	public $useCaptcha = 0;
	public $input = array("mail"=>"","activationCode"=>"");
	public $activationCode = "";

	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		

	}
	
	/**
	 * @see Form::submit()
	 */
	public function submit() {
		parent::submit();
		
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		
		if(SECURITY_BLOCKTYPE == "access") {
			$this->useCaptcha = 1;
			
			if(empty($this->input['mail'])) {	
				throw new UserInputException('email');
			}
			
			if(!UserRegistrationUtil::isValidEmail($this->input['mail'])) {
				throw new UserInputException('email', 'notValid');
			}
			
			if(StringUtil::toLowerCase($this->input['mail']) != StringUtil::toLowerCase(WCF::getUser()->email)) {
				throw new UserInputException('email', 'error');
			}
		}
		
		if(SECURITY_BLOCKTYPE == "activate") {
			if(empty($this->input['activationCode'])) {	
				throw new UserInputException('activationCode');
			}
			
			$row = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_user_access_activation` WHERE `userid`='".WCF::getUser()->userID."' AND `activationCode`='".addslashes($this->input['activationCode'])."'");
				if(isset($row['activationCode'])) $this->activationCode = $row['activationCode'];
			
			if(!isset($row['activationCode']) OR empty($row['activationCode'])) {
				throw new UserInputException('activationCode', 'notValid');
			}
			
			if($row['expiry'] < time()) {
				throw new UserInputException('activationCode', 'expired');
			}	
		}	
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		if(SECURITY_BLOCKTYPE == "honeypot") {
			WCF::getDB()->sendQuery("DELETE FROM `wcf".WCF_N."_security_honeypot` WHERE `ipAddress`='".addslashes($_SERVER['REMOTE_ADDR'])."' AND `browser`='".addslashes($_SERVER['HTTP_USER_AGENT'])."' AND `host`='".addslashes(gethostbyaddr($_SERVER['REMOTE_ADDR']))."'");
			WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.honeypot.php');
			
			header("Location: index.php".SID_ARG_1ST);
			exit;
		}
		
		if(SECURITY_BLOCKTYPE == "access") {
			$activationCode = UserRegistrationUtil::getActivationCode();
			WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_user_access_activation` (`id`, `userID`, `activationCode`, `expiry`) VALUES (NULL , '".WCF::getUser()->userID."', '".addslashes($activationCode)."', '".(time()+3600)."');");
			
			require_once(WCF_DIR.'lib/data/mail/Mail.class.php');
			
			// send activation mail
			$mail = new Mail(WCF::getUser()->email,
						WCF::getLanguage()->get('wcf.security.error.unlock.mail.subject'),
						WCF::getLanguage()->get('wcf.security.error.unlock.mail', array('$activationCode' => $activationCode)));
			$mail->send();
			
			header("Location: index.php?form=SecurityUnlock&action=activate".SID_ARG_2ND);
			exit;
		}
				
		if(SECURITY_BLOCKTYPE == "activate") {
			WCF::getDB()->sendQuery("DELETE FROM `wcf".WCF_N."_security_user_access` WHERE `userid`='".WCF::getUser()->userID."'");
			WCF::getDB()->sendQuery("DELETE FROM `wcf".WCF_N."_security_user_access_activation` WHERE `userid`='".WCF::getUser()->userID."'");

			WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.access.user.php');
			
			header("Location: index.php".SID_ARG_1ST);
			exit;
		}
		
	}
	
	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		foreach(array("mail","activationCode") as $key) {
			if(isset($_REQUEST[$key])) {
				$this->input[$key] = $_REQUEST[$key];
			}
		}
		
		
	}
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
	
		if(!defined("SECURITY_BLOCKTYPE")) define("SECURITY_BLOCKTYPE",$_REQUEST['action']);
		
		switch(SECURITY_BLOCKTYPE) {
			case "honeypot": $this->useCaptcha = 1; break;
			case "access": $this->useCaptcha = 1; break;
		}
						
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
					

		if(SECURITY_BLOCKTYPE == "mail") {
			
			if(isset($_REQUEST['pageNo'])) $page = $_REQUEST['pageNo'];
				else $page = 0;
			
			$fireback = array();
			$domain = array("at","de","ch","com","net","org","eu","info","biz","us");
				for($i=1;$i<=30;$i++) {
					$fireback[] = $this->createString(rand(7,12),1)."@".$this->createString(rand(6,9),0).".".$domain[rand(0,count($domain)-1)];
				}
				
			WCF::getTPL()->assign(array('fireback' => $fireback,"page"=>$page));
		}
		
		
		WCF::getTPL()->assign(array('input' => $this->input));
	}

	
	protected function createString($length,$numbers) {
		if($numbers == 1) {
			$chain = "abcdefghijklmnopqrstuvwxyz1234567890"; 
		} else {
			$chain = "abcdefghijklmnopqrstuvwxyz"; 
		}
			
		$string = ""; 
	
        for($i=1;$i<=$length;$i++) {
        	$string.=$chain[mt_rand(0,strlen($chain)-1)]; 
       	}
       	
       	return $string;
	}

	/**
	 * @see Page::show()
	 */
	public function show() {


			
		parent::show();
	}

}
?>