<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityUpdatePage extends AbstractPage {
	public $templateName = 'securityUpdate';
	public $activeMenuItem = 'wcf.acp.menu.link.security.service.update';
	public $neededPermissions = 'admin.security.canViewUpdate';
	
	protected $updates = array();
	
	/**
	 * @see Page::readData()
	 */
	public function readData(){
		parent::readData();
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_liveupdate_backup` ORDER BY `id` ASC");
		while($row = WCF::getDB()->fetchArray($result)) {
			if(!isset($this->updates[$row['time']])) $this->updates[$row['time']] = array();
			$this->updates[$row['time']][] = $row;	
		}
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
				
		// enable menu item
		if (!empty($this->activeMenuItem)) WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		
		// check permission
		if (!empty($this->neededPermissions)) WCF::getUser()->checkPermission($this->neededPermissions);
		
		
		// show page
		parent::show();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		
		if(isset($_REQUEST['update'])) {
			$updateDone = true;
		} else {
			$updateDone = false;
		}
		
		WCF::getTPL()->assign(array(
			'updates'=>$this->updates,
			'success'=>$updateDone
		));
	}
}
?>