<?php
require_once(WCF_DIR.'lib/page/SortablePage.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityTransferPage extends SortablePage {
	public $itemsPerPage = 40;
	public $templateName = 'securityTransfer';
	public $neededPermissions = 'admin.security.canViewDatatransfer';
	public $income = array();
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if(isset($_REQUEST['action']) AND $_REQUEST['action'] == "delete") {
			WCF::getDB()->sendQuery("TRUNCATE TABLE `wcf".WCF_N."_security_income`");
		}
	}
	
	/**
	 * @see SortablePage::validateSortField()
	 */
	public function validateSortField() {
		parent::validateSortField();
		
		switch ($this->sortField) {
			case 'id': $this->sortField = 'id'; break;
			case 'request': $this->sortField = 'request'; break;
			case 'referer': $this->sortField = 'referer'; break;
			default: $this->sortField = 'time';
		}
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		

		if(isset($_REQUEST['sortField'])) { $this->sortField = $_REQUEST['sortField']; } else { $this->sortField = "time"; }
		if(isset($_REQUEST['sortOrder'])) { $this->sortOrder = $_REQUEST['sortOrder']; } else { $this->sortOrder = "DESC"; }
		
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_income`  ORDER BY `".$this->sortField."` ".$this->sortOrder."  LIMIT ".$this->itemsPerPage." OFFSET ".($this->pageNo - 1) * $this->itemsPerPage);
		while($row = WCF::getDB()->fetchArray($result)) {
			
			$domain = parse_url($row['referer']);
			if(isset($domain['host']) AND file_exists(WCF_DIR."images/security/icon/".$domain['host'].".ico")) $row['icon'] = RELATIVE_WCF_DIR."images/security/icon/".$domain['host'].".ico";
				else $row['icon'] = RELATIVE_WCF_DIR."icon/securityTransferIconS.png";
				
			$row['shortURL'] = $row['referer'];
			if(strlen($row['shortURL']) > 80) {
				$row['shortURL'] = substr($row['referer'],0,80)."...";
			}
			

			$this->income[] = $row;
		}
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$tableFields = array(); $fields = array("id","time","referer");
		foreach($fields as $field) {
			$tableFields[] = array("field"=>$field,"name"=>"wcf.acp.security.transfer.".$field);
		}
		
		WCF::getTPL()->assign(array(
			'income' => $this->income,
			'fields' => $fields,
			'tableHeader' => $tableFields
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		WCFACP::getMenu()->setActiveMenuItem('wcf.acp.menu.link.security.logs.transfer');
		
		// check permission
		//WCF::getUser()->checkPermission('');
		
		parent::show();
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();

		$row = WCF::getDB()->getFirstRow("SELECT count(*) as `count` FROM `wcf".WCF_N."_security_income`");
		WCF::getTPL()->assign(array('count' => $row['count']));
		return $row['count'];
	}
}
?>