<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/data/message/bbcode/BBCodeParser.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityReleaseNotesPage extends AbstractPage {
	public $templateName = 'securityReleaseNotes';
	public $activeMenuItem = 'wcf.acp.menu.link.security.system.releaseNotes';
	public $neededPermissions = 'admin.security.canViewReleaseNotes';
	
	protected $versions = array();
	
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		WCF::getCache()->addResource('bbcodes', WCF_DIR.'cache/cache.bbcodes.php', WCF_DIR.'lib/system/cache/CacheBuilderBBCodes.class.php');
		WCF::getCache()->addResource('smilies', WCF_DIR.'cache/cache.smilies.php', WCF_DIR.'lib/system/cache/CacheBuilderSmilies.class.php');
		
		$parser = new BBCodeParser('text/html');
		
		$result = WCF::getDB()->sendQuery("SELECT * FROM `wcf".WCF_N."_security_releases` ORDER BY `id` DESC LIMIT 0 , 2");
		while($row = WCF::getDB()->fetchArray($result)) {	
			if(empty($row['file'])) {
				$row['changes'] = $parser->parse($row['changes']);
			} else {
				$row['changes'] = $parser->parse(utf8_encode(file_get_contents(WCF_DIR.$row['file'])));
			}
			
			$this->versions[] = $row;
		}
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// enable menu item
		if (!empty($this->activeMenuItem)) WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		
		// check permission
		if (!empty($this->neededPermissions)) WCF::getUser()->checkPermission($this->neededPermissions);
		
		
		// show page
		parent::show();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'versions' => $this->versions
		));
	}
}
?>