<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/system/security/config.inc.php');


//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityGeneralPage extends AbstractPage {
	public $templateName = 'securityGeneral';
	public $activeMenuItem = 'wcf.acp.menu.link.security.system.general';
	public $neededPermissions = 'admin.security.canViewInfo';
	
	public $plugins = array();
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		foreach($this->getPlugins() as $plugin) {
			
			unset($activePlugin,$config,$fields,$exceptions,$package);
			require(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
			
			if(empty($package['license'])) $package['license'] = "unknown";
			
			$this->plugins[$plugin] = $package;
		}
		
	}
	
	protected function getPlugins() {
		$plugins = array();
		
		foreach(scandir(WCF_DIR."lib/system/security/plugins/") as $plugin) {
			if($plugin != "." AND $plugin != ".." AND file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php")) {
				$plugins[] = $plugin;
			}
		}
		
		return $plugins;
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		
		// enable menu item
		if (!empty($this->activeMenuItem)) WCFACP::getMenu()->setActiveMenuItem($this->activeMenuItem);
		
		// check permission
		if (!empty($this->neededPermissions)) WCF::getUser()->checkPermission($this->neededPermissions);
		
		
		// show page
		parent::show();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'plugins' => $this->plugins,
			'productURL' => "http://www.wbb-security.de/support/index.php?page=Products&category=view&id=".SECURITY_PRODUCTID
		));
	}
}
?>