<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/system/exception/PermissionDeniedException.class.php');
	
/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */	
class SecurityBlacklistActionPage extends AbstractPage {
	public $blacklistItemID = 0;
	public static $validFunctions = array('mark', 'unmark', 'unmarkAll', 'deleteMarked', 'blockMarked', 'ignoreMarked');
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['blacklistID'])) $this->blacklistItemID = ArrayUtil::toIntegerArray($_REQUEST['blacklistID']);

		
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		parent::show();
		
		if (in_array($this->action, self::$validFunctions)) {
			$this->{$this->action}();
		}
	}
	
	/**
	 * Marks an user.
	 */
	public function mark() {
		if (!is_array($this->blacklistItemID)) $this->blacklistItemID = array($this->blacklistItemID);
		foreach ($this->blacklistItemID as $blacklistItemID) {
			$markedBlacklistItems = WCF::getSession()->getVar('markedBlacklistItems');
			if ($markedBlacklistItems == null || !is_array($markedBlacklistItems)) { 
				$markedBlacklistItems = array($blacklistItemID);
				WCF::getSession()->register('markedBlacklistItems', $markedBlacklistItems);
			}
			else {
				if (!in_array($blacklistItemID, $markedBlacklistItems)) {
					array_push($markedBlacklistItems, $blacklistItemID);
					WCF::getSession()->register('markedBlacklistItems', $markedBlacklistItems);
				}
			}
		}
	}
	
	/**
	 * Unmarks an entry.
	 */
	public function unmark() {
		if (!is_array($this->blacklistItemID)) $this->blacklistItemID = array($this->blacklistItemID);
		foreach ($this->blacklistItemID as $blacklistItemID) {
			$markedBlacklistItems = WCF::getSession()->getVar('markedBlacklistItems');
			if (is_array($markedBlacklistItems) && in_array($blacklistItemID, $markedBlacklistItems)) {
				$key = array_search($blacklistItemID, $markedBlacklistItems);
				
				unset($markedBlacklistItems[$key]);
				if (count($markedBlacklistItems) == 0) {
					self::unmarkAll();
				} 
				else {
					WCF::getSession()->register('markedBlacklistItems', $markedBlacklistItems);
				}
			}
		}
	}
	
	/**
	 * Unmarks all marked entries.
	 */
	public static function unmarkAll() {
		WCF::getSession()->unregister('markedBlacklistItems');
	}
	
	/**
	 * Deletes marked entry.
	 */
	public function deleteMarked() {
		//WCF::getUser()->checkPermission('admin.user.canDeleteUser');
		
		$blacklistItemIDs = WCF::getSession()->getVar('markedBlacklistItems');	
		if (!is_array($blacklistItemIDs)) $blacklistItemIDs = array();

		// check permission
		if (count($blacklistItemIDs) > 0) {
			WCF::getDB()->sendQuery("DELETE FROM wcf".WCF_N."_security_blacklist WHERE `id` IN (".implode(',', $blacklistItemIDs).")");
			WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.blacklist.php');
		}
		
		self::unmarkAll();
		HeaderUtil::redirect('index.php?page=SecurityBlacklist&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	
	public function blockMarked() {
		//WCF::getUser()->checkPermission('admin.user.canDeleteUser');
		
		$blacklistItemIDs = WCF::getSession()->getVar('markedBlacklistItems');	
		if (!is_array($blacklistItemIDs)) $blacklistItemIDs = array();

		// check permission
		if (count($blacklistItemIDs) > 0) {
			WCF::getDB()->sendQuery("UPDATE wcf".WCF_N."_security_blacklist SET `status`='block' WHERE `id` IN (".implode(',', $blacklistItemIDs).")");
			WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.blacklist.php');
		}
		
		self::unmarkAll();
		HeaderUtil::redirect('index.php?page=SecurityBlacklist&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	
	public function ignoreMarked() {
		//WCF::getUser()->checkPermission('admin.user.canDeleteUser');
		
		$blacklistItemIDs = WCF::getSession()->getVar('markedBlacklistItems');	
		if (!is_array($blacklistItemIDs)) $blacklistItemIDs = array();

		// check permission
		if (count($blacklistItemIDs) > 0) {
			WCF::getDB()->sendQuery("UPDATE wcf".WCF_N."_security_blacklist SET `status`='ignore' WHERE `id` IN (".implode(',', $blacklistItemIDs).")");
			WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.blacklist.php');
		}
		
		self::unmarkAll();
		HeaderUtil::redirect('index.php?page=SecurityBlacklist&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	

}
?>