<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/system/exception/PermissionDeniedException.class.php');
	
/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */	
class SecurityAttacksActionPage extends AbstractPage {
	public $attackJournalID = 0;
	public static $validFunctions = array('mark', 'unmark', 'unmarkAll', 'deleteMarked', 'download', 'downloadMarked');
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['attackID'])) $this->attackJournalID = ArrayUtil::toIntegerArray($_REQUEST['attackID']);

		
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		parent::show();
		
		if (in_array($this->action, self::$validFunctions)) {
			$this->{$this->action}();
		}
	}
	
	/**
	 * Marks an user.
	 */
	public function mark() {
		if (!is_array($this->attackJournalID)) $this->attackJournalID = array($this->attackJournalID);
		foreach ($this->attackJournalID as $attackJournalID) {
			$markedAttacks = WCF::getSession()->getVar('markedAttacks');
			if ($markedAttacks == null || !is_array($markedAttacks)) { 
				$markedAttacks = array($attackJournalID);
				WCF::getSession()->register('markedAttacks', $markedAttacks);
			}
			else {
				if (!in_array($attackJournalID, $markedAttacks)) {
					array_push($markedAttacks, $attackJournalID);
					WCF::getSession()->register('markedAttacks', $markedAttacks);
				}
			}
		}
	}
	
	/**
	 * Unmarks an entry.
	 */
	public function unmark() {
		if (!is_array($this->attackJournalID)) $this->attackJournalID = array($this->attackJournalID);
		foreach ($this->attackJournalID as $attackJournalID) {
			$markedAttacks = WCF::getSession()->getVar('markedAttacks');
			if (is_array($markedAttacks) && in_array($attackJournalID, $markedAttacks)) {
				$key = array_search($attackJournalID, $markedAttacks);
				
				unset($markedAttacks[$key]);
				if (count($markedAttacks) == 0) {
					self::unmarkAll();
				} 
				else {
					WCF::getSession()->register('markedAttacks', $markedAttacks);
				}
			}
		}
	}
	
	/**
	 * Unmarks all marked entries.
	 */
	public static function unmarkAll() {
		WCF::getSession()->unregister('markedAttacks');
	}
	
	/**
	 * Deletes marked entry.
	 */
	public function deleteMarked() {
		//WCF::getUser()->checkPermission('admin.user.canDeleteUser');
		
		$attackJournalIDs = WCF::getSession()->getVar('markedAttacks');	
		if (!is_array($attackJournalIDs)) $attackJournalIDs = array();

		// check permission
		if (count($attackJournalIDs) > 0) {
			$result = WCF::getDB()->sendQuery("UPDATE wcf".WCF_N."_security_attacks SET `hidden`='1' WHERE `id` IN (".implode(',', $attackJournalIDs).")");
		}
		
		self::unmarkAll();
		HeaderUtil::redirect('index.php?page=SecurityAttacks&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	public function download() {
		$journal = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_attacks` WHERE `id`='".intval($this->attackJournalID)."'");
		if($journal['id'] == 0) {
			require_once(WCF_DIR.'lib/system/exception/IllegalLinkException.class.php');
			throw new IllegalLinkException();
		}
		
			if(preg_match("/Opera\/[0-9]\.[0-9]{1,2}/", $_SERVER['HTTP_USER_AGENT']) || preg_match("/MSIE [0-9]\.[0-9]{1,2}/", $_SERVER['HTTP_USER_AGENT'])) {
				$mime_type = "application/octetstream";
			} else {
				$mime_type = "application/octet-stream";
			}		
		
	        header("Expires: ".date("D, d M Y H:i:s"));
	        header("Content-Type: ".$mime_type);
	        if (preg_match("/MSIE [0-9]\.[0-9]{1,2}/", $_SERVER['HTTP_USER_AGENT'])) {
	        	header("Content-Disposition: inline; filename=\"attackJournal.xml\"");
	        	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	            header("Pragma: public");
	        } else {
	            header("Content-Disposition: attachment; filename=\"attackJournal.xml\"");
	            header("Pragma: no-cache");
	        }
	        
	        echo $journal['journal'];
	        exit;
	}
	
	public function downloadMarked() {
		$attackJournalIDs = WCF::getSession()->getVar('markedAttacks');	
		if (!is_array($attackJournalIDs)) $attackJournalIDs = array($attackJournalIDs);
		

		if (count($attackJournalIDs) > 0) {
			if(count($attackJournalIDs) == 1) {
				self::unmarkAll();
				$this->attackJournalID = array_pop($attackJournalIDs);
				$this->download();
			} else {
				require_once(WCF_DIR.'lib/system/io/TarWriter.class.php');
							
				header('Content-Type: application/x-gzip; charset='.CHARSET);
				header('Content-Disposition: attachment; filename="attackJournals.tgz"');
				
				$exportTarName = FileUtil::getTemporaryFilename('attackJournals', '.tgz');
				
				//create tar archive
				$archive = new TarWriter($exportTarName, true);
				$result = WCF::getDB()->sendQuery("SELECT * FROM wcf".WCF_N."_security_attacks WHERE `id` IN (".implode(',', $attackJournalIDs).")");
				while($row = WCF::getDB()->fetchArray($result)) {
					$archive->addString("attackJournal_".$row['id'].".xml", $row['journal']);
				}
				
				$archive->create();
				
				//unmarkAll
				self::unmarkAll();
				
				//read tempFile and deletes it afterwords
				readfile($exportTarName);
				@unlink($exportTarName);
				
			}
		}
		
		self::unmarkAll();
		HeaderUtil::redirect('index.php?page=SecurityAttacks&packageID='.PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
}
?>