<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityLoginForm extends ACPForm {
	public $templateName = 'securityAdminLogin';
	public $activeMenuItem = 'wcf.acp.menu.link.security.config.system';
	public $neededPermissions = '';
	
	protected $password = "";
	protected $id = 0;
	protected $data = array("get"=>array(),"post"=>array());
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		

	}
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if(isset($_REQUEST['id'])) {
			$this->id = intval($_REQUEST['id']);
		}
	}
	
	/**
	 * @see Page::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();

		if(isset($_REQUEST['masterpassword'])) $this->password = $_REQUEST['masterpassword'];
		if(isset($_REQUEST['securityLoginDataID'])) $this->id = $_REQUEST['securityLoginDataID'];
		
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if(empty($this->password)) {
			throw new UserInputException('masterpassword');
		}
		
		require(WCF_DIR."lib/system/security/storage/system/encryption.inc.php");
		
		if(md5(md5($this->password).$encryptionHash) != $masterpassword) {
			throw new UserInputException('masterpassword','notValid');
		}
		
		
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();

		
	/*
		if(in_array($this->targetType,array("page","form","action")) AND $this->targetValue != "") {
			header("Location: index.php?".$this->targetType."=".$this->targetValue."&packageID=".PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		} else {
			header("Location: index.php?form=SecurityConfig&packageID=".PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		}
	*/
		//insert SessionID
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_adminsessions` (`id`,`sessionID`,`ipAddress`,`host`, `time`) VALUES (NULL , '".addslashes(SID)."', '".addslashes($_SERVER['REMOTE_ADDR'])."', '".addslashes(gethostbyaddr($_SERVER['REMOTE_ADDR']))."','".TIME_NOW."')");
		
		//get header data ($_GET)
		$row = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_security_adminsessions_input` WHERE `id`='".intval($this->id)."' AND `sid`='".addslashes(SID)."'");
		if($row['id']) {
			$this->data = unserialize($row['input']);
		}
		

		if(!isset($this->data['get']['packageID'])) {
			$this->data['get']['packageID'] = PACKAGE_ID;
		}
		
		if(!isset($this->data['get']['s'])) {
			$this->data['get']['s'] = SID;
		}
		
		$this->data['get']['securityLoginDataID'] = $this->id;
		
		//get
		$urlString = http_build_query($this->data['get']);
			$urlString = str_replace("%5B","[",$urlString);
			$urlString = str_replace("%5D","]",$urlString);
			$urlString = str_replace("&amp;","&",$urlString);
			
		header("Location: index.php?".$urlString);
		exit;
	}
	
	protected function getURLArrayKey($item,$value) {
		if(is_array($value)) {
			foreach($value as $key=>$newValue) {
				return $item."[".$this->getURLArrayKey($key,$newValue)."]";
			}
		} else {
			return $item."[".$value."]";
		}
	}
		
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'dataID' => $this->id,
			//'postData' => $this->getPostData()
		));
	}
	
/*	protected function getPostData() {
		if(!isset($this->data['post'])) {
			return array();
		}
		
		$urlString = http_build_query($this->data['post']);
			$urlString = str_replace("%5B","[",$urlString);
			$urlString = str_replace("%5D","]",$urlString);
		
		$postData = array();	
			
		$data = explode("&amp;",$urlString);
		foreach($data as $string) {
			$string = explode("=",$string);
			if(!in_array($string[0],array("s","packageID"))) {
				$postData[$string[0]] = $string[1];
			}
		}
		
		return $postData;
	} */
}
?>