<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityExceptionsEditForm extends ACPForm {
	public $templateName = 'securityExceptionEdit';
	public $activeMenuItem = 'wcf.acp.menu.link.security.config.exceptions';
	public $neededPermissions = 'admin.security.canEditExceptions';
		
	protected $classType = "";
	protected $classFile = "";
	
	protected $plugins = array();
	protected $exceptions = array();
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readFormParameters();
		
		if(isset($_REQUEST['classFile'])) $this->classFile = $_REQUEST['classFile'];
		if(isset($_REQUEST['classType'])) $this->classType = $_REQUEST['classType'];
		if(isset($_REQUEST['exceptions'])) $this->exceptions = $_REQUEST['exceptions'];
				
		if(!$this->searchFile()) {
			header("Location:index.php?form=SecurityExceptions&packageID=".PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
			exit;
		}
	}
	
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		
		
		foreach($this->getPlugins() as $plugin) {
			unset($activePlugin,$config,$fields,$exceptions,$package);
			require_once(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
			
			if(isset($exceptions[$this->classFile])) {
				$this->plugins[$plugin] = $exceptions[$this->classFile];
			} else {
				$this->plugins[$plugin] = -1;
			}
		}
		
	}
	
	protected function getPlugins() {
		$plugins = array();
		
		foreach(scandir(WCF_DIR."lib/system/security/plugins/") as $plugin) {
			if($plugin != "." AND $plugin != ".." AND file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php") AND !file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/__config.lock")) {
				$plugins[] = $plugin;
			}
		}
		
		return $plugins;
	}
		
	protected function searchFile() {
	
		$package = WCF::getDB()->getFirstRow("SELECT * FROM `wcf".WCF_N."_package` WHERE `packageID`='".intval(PACKAGE_ID)."'");
		if(!empty($package['packageDir'])) {
			if(file_exists(WCF_DIR.$package['packageDir']."lib/".$this->classType."/".$this->classFile.".class.php")) {
				return true;
			}
		}
		
		//wcf
		if(file_exists(WCF_DIR."lib/".$this->classType."/".$this->classFile.".class.php")) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		


	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		if(count($this->exceptions) > 0) {
			foreach($this->exceptions as $plugin => $exceptionConfig) {
				if(($exceptionConfig == -1 OR $exceptionConfig == 0 OR $exceptionConfig == 1) AND file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php")) {
					unset($activePlugin,$config,$fields,$exceptions,$package);
					require_once(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
					
					if(isset($exceptions[$this->classFile])) {
						$pluginException = $exceptions[$this->classFile];
					} else {
						$pluginException = -1;
					}
					
					if($exceptionConfig != $pluginException) {
						
						//echo "rewrite PluginConfig ".$plugin."<br />";
						
						$file = file_get_contents(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
							$file = str_replace("\t\t\$exceptions['".$this->classFile."'] = ".$pluginException.";","",$file);
							
						if($exceptionConfig == 0 OR $exceptionConfig == 1) {
							$file = str_replace("\$exceptions = array();","\$exceptions = array();\n\t\t\$exceptions['".$this->classFile."'] = ".$exceptionConfig.";",$file);
						}
						
						$fp = fopen(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php","w");
							@fwrite($fp,$file);
							@fclose($fp);
							
						@chmod(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php",0777);
					}
				}
			}
		}
		
		
		header("Location:index.php?form=SecurityExceptions&packageID=".PACKAGE_ID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
				
		WCF::getTPL()->assign(array(
			'classFile' => $this->classFile,
			'classType' => $this->classType,
			'plugins' => $this->plugins
		));
	}
}
?>