<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityConfigForm extends ACPForm {
	public $templateName = 'securityConfig';
	public $activeMenuItem = 'wcf.acp.menu.link.security.config.system';
	public $neededPermissions = 'admin.security.canEditConfig';
	
	protected $plugins = array();
	protected $categories = array();
	
	protected $input = array();
	protected $writeCache = array();
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		//require_once(WCF_DIR."lib/system/security/plugins/system/SecurityConfigWriter.class.php");
		//$s = new SecurityConfigWriter();
		
		$this->readPlugins();
	}
	
	protected function readPlugins() {
		foreach($this->getPlugins() as $plugin) {
			
			unset($activePlugin,$config,$fields,$exceptions,$package);
			require(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
			
			$configString = array();
			foreach($config as $key=>$value) {
				$this->input[$key] = $value;
				$configString[] = "'".$key."'";
			}
			
			if(!in_array($package['category'],$this->categories)) {
				$this->categories[] = $package['category'];
			}
			
			$this->plugins[$package['category']][$plugin] = array("activePlugin"=>$activePlugin,"config"=>$config,"fields"=>$fields,"package"=>$package,"configString"=>implode(",",$configString));
				$this->input[$plugin] = $activePlugin;
		}
	}
	
	protected function getPlugins() {
		$plugins = array();
		
		foreach(scandir(WCF_DIR."lib/system/security/plugins/") as $plugin) {
			if($plugin != "." AND $plugin != ".." AND file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php")) {
				if(!file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/__config.lock")) {
					$plugins[] = $plugin;
				}
			}
		}
		
		return $plugins;
	}
	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		$this->readPlugins();
		
		foreach($this->input as $key=>$value) {
			if(!intval($key)) {
				$this->input[$key] = 0;
			}
		}
		
		if(isset($_POST) AND count($_POST) > 0) {
			foreach($_POST as $key=>$value) {
				if(!intval($key)) {
					$this->input[$key] = $value;
				}
			}
		}
		
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		foreach($this->getPlugins() as $plugin) {
			unset($activePlugin,$config,$fields,$exceptions,$package);
			require(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
			
			if(count($fields) > 0 AND $this->input[$plugin] == 1) {
				foreach($fields as $key=>$options) {
					if(!isset($this->input[$key])) {
						$this->input[$key] = "";
					}
					
					if($options['required'] == 1 AND empty($this->input[$key])) {
						throw new UserInputException($key,'empty');
					}
					
					
					//type validation
					if($options['type'] == "integer") {
						if(!intval($this->input[$key])) {
							throw new UserInputException($key,'notValid');
						}
						
						//limits
						if($options['min'] AND $this->input[$key] < $options['min']) {
							throw new UserInputException($key,'minLimit');
						}
						
						if($options['max'] AND $this->input[$key] > $options['max']) {
							throw new UserInputException($key,'maxLimit');
						}					
					}
					
					if($options['type'] == "url") {
						if(!preg_match('/(?#WebOrIP)((?#protocol)((http|https):\/\/)?(?#subDomain)(([a-zA-Z0-9]+\.(?#domain)[a-zA-Z0-9\-]+(?#TLD)(\.[a-zA-Z]+){1,2})|(?#IPAddress)((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])))+(?#Port)(:[1-9][0-9]*)?)+(?#Path)((\/((?#dirOrFileName)[a-zA-Z0-9_\-\%\~\+]+)?)*)?(?#extension)(\.([a-zA-Z0-9_]+))?(?#parameters)(\?([a-zA-Z0-9_\-]+\=[a-z-A-Z0-9_\-\%\~\+]+)?(?#additionalParameters)(\&([a-zA-Z0-9_\-]+\=[a-z-A-Z0-9_\-\%\~\+]+)?)*)?/i', $this->input[$key], $m)) {
							if(!empty($this->input[$key])) {
								throw new UserInputException($key,'notValid');
							}
						}
					}
					
					if($options['type'] == "boolean") {
						if($this->input[$key]) {
							$this->input[$key] = 1;
						} else {
							$this->input[$key] = 0;
						}
					}
				}
			}
			
		}
	}
	
	/**
	 * saves config and rewrites config file
	 *
	 * @param String $plugin
	 */
	protected function rewriteConfig($plugin) {
		if(!in_array($plugin,$this->writeCache)) {
			if(file_exists(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php")) {
				require(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
				
				//echo "rewrite $plugin (".$this->input[$plugin].")<br />";
			
				$source = file_get_contents(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
				if($activePlugin != $this->input[$plugin]) {
					$source = str_replace("\$activePlugin = ".$activePlugin.";","\$activePlugin = ".$this->input[$plugin].";",$source);
				} 
				
				if($this->input[$plugin] == 1) {
					
					//echo "rewrite Subconfig($plugin)<br />";
					
					foreach($config as $key=>$value) {
						if($this->input[$key] != $value) {
							$source = str_replace("\$config['".$key."'] = ".$value.";","\$config['".$key."'] = ".$this->input[$key].";",$source);
							$source = str_replace("\$config['".$key."'] = \"".addslashes($value)."\";","\$config['".$key."'] = \"".$this->input[$key]."\";",$source);
						}
					}
				}
				
				@chmod(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php",0777);
				
				//saves config
				$fp = fopen(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php","w");
					@fwrite($fp,$source);
					@fclose($fp);
	
			} else {
				throw new SystemException("Couldn' find config file of plugin \"".$plugin."\"");
			}
				
			$this->writeCache[] = $plugin;
		}
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		//print_r($this->input);
		
		foreach($this->getPlugins() as $plugin) {
			unset($activePlugin,$config,$fields,$exceptions,$package);
			require(WCF_DIR."lib/system/security/plugins/".$plugin."/config.inc.php");
						
		/*	if(!isset($this->input[$plugin])) $this->input[$plugin] = 0;
				else $this->input[$plugin] = 1;	*/
			
		//	echo "PLUGIN: ".$plugin."<br />";
		//	echo "active: ".$activePlugin." -> ".$this->input[$plugin]."<br />";
			
			if($activePlugin != $this->input[$plugin]) {
				$this->rewriteConfig($plugin);
			} 
			
			if($this->input[$plugin] == 1) {
				foreach($config as $key=>$value) {
					if($this->input[$key] != $value) {
						$this->rewriteConfig($plugin);
					}
				}
			}
		}
		
		//reload config files
		$this->readPlugins();
		
		// show success.
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'plugins' => $this->plugins,
			'categories' => $this->categories,
			'input' => $this->input,
			'systemFile' => WCF_DIR."lib/system/security/cache/cache.system.php"
		));
	}
}
?>