<?php
require_once(WCF_DIR.'lib/acp/form/ACPForm.class.php');
require_once(WCF_DIR.'lib/page/util/InlineCalendar.class.php');

//constants
if(!defined("SECURITY_ACTION")) define("SECURITY_ACTION",1);

/**
 * @author		Peter Fruehwirt
 * @package		de.wbb-security.premium
 * @copyright	www.wbb-security.de 2005-2008 
 */
class SecurityBlacklistAddForm extends ACPForm {
	public $templateName = 'securityBlacklistAdd';
	public $activeMenuItem = 'wcf.acp.menu.link.security.protection.blacklist.add';
	public $neededPermissions = 'admin.security.canEditBlacklist';
	
	protected $input = array("host"=>"","browser"=>"","ip1"=>"","ip2"=>"","ip3"=>"","ip4"=>"", "type"=>0, "blockType"=>0, "expire"=>0, "expireDay"=>0, "expireMonth"=>0, "expireYear"=>0, "expireHour"=>0, "expireMinutes"=>0);

	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		foreach($this->input as $key=>$value) {
			if(isset($_REQUEST[$key])) {
				$this->input[$key] = $_REQUEST[$key]; 
			}
		}
		
		$this->input['ip'] = $this->input['ip1'].".".$this->input['ip2'].".".$this->input['ip3'].".".$this->input['ip4'];
		$this->input['expireTime'] = mktime($this->input['expireHour'],$this->input['expireMinutes'],0,$this->input['expireMonth'],$this->input['expireDay'],$this->input['expireYear']);
	}

	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
	}
	
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();

		//ip
		if($this->input['type'] == 0) {
			
			if($this->input['ip'] == "...") {
				throw new UserInputException('ip');
			}
			
			if(!ereg("[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}",str_replace("?","0",$this->input['ip']))) {
				throw new UserInputException('ip','notValid');
			}
			
		//browser
		} elseif($this->input['type'] == 1) {
			if(empty($this->input['browser'])) {
				throw new UserInputException('browser');
			}
		//host
		} elseif($this->input['type'] == 2) {
			if(empty($this->input['host'])) {
				throw new UserInputException('host');
			}
		} else {
			//type is not valid
			throw new UserInputException('type');
		}
		
		//blocktype is not valid
		if($this->input['blockType'] != 0 AND $this->input['blockType'] != 1) {
			throw new UserInputException('blockType');
		}
		
		if($this->input['expire'] != 1 AND $this->input['expireTime'] <= TIME_NOW) {
			throw new UserInputException('expire','noValidTime');
		}
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		switch($this->input['type']) {
			case '0': $object="ip"; break;
			case '1': $object="browser"; break;
			case '2': $object="host"; break;
		}
		
		switch($this->input['blockType']) {
			case '0': $status="block"; break;
			case '1': $status="ignore"; break;
		}
		
		if($this->input['expire'] == 1) {
			$validility = -1;
		} else {
			$validility = $this->input['expireTime'];
		}
		
		//insert into database
		WCF::getDB()->sendQuery("INSERT INTO `wcf".WCF_N."_security_blacklist` (`id`,`object`,`value`,`status`,`validity`) VALUES (NULL , '".$object."', '".$this->input[$object]."', '".$status."', '".$validility."')");

		//clear cache
		WCF::getCache()->clear(WCF_DIR.'lib/system/security/cache/', 'cache.blacklist.php');
		
		// show success.
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		InlineCalendar::assignVariables();
		
		if($this->input['expireDay'] == 0 AND $this->input['expireMonth'] == 0 AND $this->input['expireYear'] == 0) {
			$d = getdate(TIME_NOW);
				$this->input['expireDay'] = $d['mday'];
				$this->input['expireMonth'] = $d['mon'];
				$this->input['expireYear'] = $d['year'];
		}
		
		WCF::getTPL()->assign(array(
			'input' => $this->input
		));
	}
}
?>