<?xml version="1.0" encoding="{@CHARSET}"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="{lang}wcf.global.pageDirection{/lang}" xml:lang="{@LANGUAGE_CODE}">
	<head>
		<title>{lang}wcf.security{/lang} - {lang}wcf.global.pageTitle{/lang}</title>
		<meta http-equiv="Content-Type" content="text/html; charset={@CHARSET}" />

		<style type="text/css">
			@import url("{@RELATIVE_WCF_DIR}style/extra/securityError.css");
			@import url("{@RELATIVE_WCF_DIR}style/forms.css");
		</style>
				
	</head>
<body>


<div class="header">
	<img src="{@RELATIVE_WCF_DIR}images/security/securityLogo.png" alt="" />
</div>



<div class="page" align="center">

		
		<div style="width:80%; padding: 0px 24px 4px 0px; font-size:14px;text-align:left;">
			<b>{lang}wcf.security.error{/lang}</b>
		</div>

		<div class="content" style="width:80%; text-align:center; border: 1px #cdcdcd solid; padding:12px; font-size:14px;">
			{@$error}		
			<div style="font-size:12px;"><a href="javascript:window.back();">{lang}wcf.security.error.back{/lang}</a></div>
		</div>
	

		<div style="width:80%; padding: 4px 0px 0px 24px; font-size:14px;text-align:right;">
		
			{if SECURITY_BLOCKTYPE == "honeypot" || SECURITY_BLOCKTYPE == "access"}
				<img src="{@RELATIVE_WCF_DIR}/icon/securityUnlockS.png" alt="" style="vertical-align: middle;border:0;" /> <a href="index.php?form=SecurityUnlock&amp;action={SECURITY_BLOCKTYPE}{@SID_ARG_2ND}">{lang}wcf.security.error.unlock{/lang}</a>
			{/if}
				
			{if SECURITY_BLOCKTYPE == "honeypot" && SECURITY_HONEYPOT_FIREBACK == 1}
				<img src="{@RELATIVE_WCF_DIR}/icon/securityMailS.png" alt="" style="vertical-align: middle;border:0; padding-left:6px;" /> <a href="index.php?form=SecurityUnlock&amp;action=mail{@SID_ARG_2ND}">{lang}wcf.security.error.mail{/lang}</a>
			{/if}
			
			{if SECURITY_BLOCKTYPE == "access"}
				<img src="{@RELATIVE_WCF_DIR}/icon/logoutS.png" alt="" style="vertical-align: middle;border:0; padding-left:6px;" /> <a href="index.php?action=UserLogout&amp;u={$this->getUser()->userID}{@SID_ARG_2ND}">{lang}wcf.security.error.logout{/lang}</a>
			{/if}
					
			{if SECURITY_BLOCKTYPE == "xss"}
				<img src="{@RELATIVE_WCF_DIR}/icon/securityInputS.png" alt="" style="vertical-align: middle;border:0; padding-left:6px;" /> <a href="#" onclick="javascript:document.getElementById('xssInput').style.visibility='visible'; return false;">{lang}wcf.security.error.input{/lang}</a>
			{/if}
			
			{if $this->user->getPermission('admin.general.canUseAcp')}
				<img src="icon/acpS.png" style="vertical-align: middle;border:0; padding-left:6px;" alt="" /> <a href="acp/index.php?packageID={@PACKAGE_ID}">{lang}wbb.header.userMenu.acp{/lang}</a>
			{/if}
		</div>

		

</div>

		{if SECURITY_BLOCKTYPE == "xss"}
			<div id="xssInput" style="position:absolute; visibility:hidden; background-color:#FFFFFF; overflow:auto; top:0px; left:0px; right:0px; bottom:35px; padding:20px; border-bottom: 1px #cdcdcd solid;">

				<div style="text-align:right;">
					<img src="{@RELATIVE_WCF_DIR}/icon/securityInputS.png" alt="" style="vertical-align: middle;border:0; padding-left:6px;" /> <a href="#" onclick="javascript:document.getElementById('xssInput').style.visibility='hidden'; return false;">{lang}wcf.security.error.input.close{/lang}</a>
				</div>
			
					{foreach from=$additionals.data key=key item=item}
					
						<div class="formElement">
							<div class="formFieldLabel">
								{$key}
							</div>
							<div class="formField" style="text-align:left;">
								{$item}
							</div>
						</div>
					
					
					{/foreach}
			</div>
		{/if}
		

{if SECURITY_COPYRIGHT == 1}
	<div class="copyright"><a href="http://www.wbb-security.de/">{lang}wcf.security.copyright{/lang}</a></div>
{/if}


</body>
</html>