
CREATE TABLE `wcf1_security_accounts` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `checksum` varchar(50) NOT NULL,
  `ipAddress` varchar(15) NOT NULL default '0.0.0.0',
  `host` varchar(255) NOT NULL,
  `accessErrors` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

INSERT INTO `wcf1_security_accounts` (`id`, `username`, `password`, `checksum`, `ipAddress`, `host`, `accessErrors`) VALUES (1, 'Administrator', 'ea9b7b642e903971265725b299035aa9', 's82kso04js', '', '', 0);

CREATE TABLE `wcf1_security_accounts_errors` (
  `id` int(20) NOT NULL auto_increment,
  `account` int(5) NOT NULL,
  `time` int(5) NOT NULL,
  `ipAddress` varchar(15) NOT NULL default '0.0.0.0',
  `host` varchar(255) NOT NULL,
  `browser` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_acp_session` (
  `id` int(20) NOT NULL auto_increment,
  `sessionID` char(40) NOT NULL,
  `userID` int(20) NOT NULL,
  `username` varchar(255) NOT NULL,
  `ipAddress` varchar(15) NOT NULL default 'x.x.x.x',
  `host` varchar(255) NOT NULL,
  `browser` varchar(255) NOT NULL,
  `time` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_acp_session_data` (
  `sessionID` int(20) NOT NULL,
  `requestMethod` varchar(4) NOT NULL default 'GET',
  `class` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `time` int(5) NOT NULL,
  KEY `sessionID` (`sessionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wcf1_security_adminsessions` (
  `id` int(20) NOT NULL auto_increment,
  `sessionID` varchar(255) NOT NULL,
  `ipAddress` varchar(15) NOT NULL default 'x.x.x.x',
  `host` varchar(255) NOT NULL,
  `time` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_adminsessions_input` (
  `id` int(20) NOT NULL auto_increment,
  `sid` char(40) NOT NULL,
  `input` longtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_attacks` (
  `id` int(20) NOT NULL auto_increment,
  `type` enum('unknown','blacklist','honeypot','xss','flood','spyware','sqlInjection','access') NOT NULL default 'unknown',
  `time` int(5) NOT NULL,
  `ipAddress` varchar(15) NOT NULL default '0.0.0.0',
  `host` varchar(255) NOT NULL,
  `browser` varchar(255) NOT NULL,
  `journal` longtext NOT NULL,
  `new` tinyint(1) NOT NULL default '1',
  `hidden` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE `wcf1_security_blacklist` (
  `id` int(50) NOT NULL auto_increment,
  `object` enum('ip','browser','host') NOT NULL default 'ip',
  `value` varchar(255) NOT NULL,
  `status` enum('block','flood','ignore') NOT NULL default 'block',
  `validity` int(5) NOT NULL default '-1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_definitions` (
  `id` int(20) NOT NULL auto_increment,
  `string` varchar(255) NOT NULL,
  `object` enum('browser','ip') NOT NULL default 'browser',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=79 ;

INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(1, '8484 Boston Project', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(2, 'atSpider', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(3, 'autoemailspider', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(4, 'China Local Browse', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(5, 'ContactBot', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(6, 'ContentSmartz', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(7, 'DataCha0s', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(66, '82.208.139.1?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(9, 'DBrowse', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(10, 'Browse', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(11, 'Demo Bot DOT', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(12, 'Demo Bot Z', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(13, 'DSurf15a', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(14, 'EBrowse', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(15, 'Educate Search VxB', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(16, 'EmailSiphon', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(17, 'EmailWolf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(18, 'ESurf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(19, 'ExtractorPro', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(20, 'FSurf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(21, 'Full Web Bot', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(22, 'infoConveraCrawler', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(23, 'ISC Systems iRc Search', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(24, 'LARBIN-EXPERIMENTAL', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(25, 'LetsCrawl.com', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(26, 'Lincoln State Web Browser', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(27, 'LMQueueBot', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(28, 'LWP::Simple', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(29, 'Mac Finder', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(30, 'MFC Foundation Class Library', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(31, 'Microsoft URL Control', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(32, 'Missauga Locate', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(33, 'Missigua Locator', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(34, 'Missouri College Browse', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(35, 'Mizzu Labs', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(36, 'Mo College', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(37, 'Mozilla/4.0 (compatible; Advanced Email Extractor', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(38, 'Mozilla/4.0 (compatible; Iplexx Spider/1.0 http://www.iplexx.at)', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(39, 'DTS Agent', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(40, 'Fetch API Request', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(41, 'efp@gmx.net', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(42, 'MVAClient', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(43, 'NASA Search', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(44, 'Nsauditor', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(45, 'PBrowse', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(46, 'PEval', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(47, 'Poirot', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(48, 'Port Huron Labs', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(49, 'Production Bot', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(50, 'Program Shareware', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(51, 'PSurf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(52, 'psycheclone', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(53, 'RSurf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(54, 'searchbot admin@google.com', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(55, 'Snapbot', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(56, 'snap.com', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(57, 'sogou spider', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(58, 'Sogou web spider', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(59, 'sohu agent', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(60, 'SSurf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(61, 'TSurf', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(62, 'Under the Rainbow', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(63, 'WebVulnCrawl', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(64, 'Wells Search', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(65, 'WEP Search', 'browser');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(67, '86.123.65.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(68, '208.35.1?.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(69, '62.163.?.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(70, '62.194.?.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(71, '218.111.83.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(72, '218.149.129.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(73, '67.112.?.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(74, '217.34.59.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(75, '68.154.96.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(76, '65.66.?.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(77, '68.4.?.?', 'ip');
INSERT INTO `wcf1_security_definitions` (`id`, `string`, `object`) VALUES(78, '66.230.140.?', 'ip');

CREATE TABLE `wcf1_security_errors` (
  `id` int(20) NOT NULL auto_increment,
  `userData` int(20) NOT NULL,
  `type` enum('blacklist','honeypot','access','flood','xss') NOT NULL,
  `time` int(5) NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE `wcf1_security_help` (
  `id` int(20) NOT NULL auto_increment,
  `lang` varchar(10) NOT NULL default 'de',
  `lft` int(20) NOT NULL,
  `rgt` int(20) NOT NULL,
  `page` varchar(255) NOT NULL,
  `isIndex` tinyint(1) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(1, 'de', 1, 24, 'index', 1, 'Startseite', '', 'lib/system/security/storage/documentation/de.index.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(2, 'de', 2, 9, 'info', 1, '1. Allgemeine Informationen', '', '');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(3, 'de', 3, 4, 'info.about', 0, '1.1 Was ist das SecuritySystem premium?', '', 'lib/system/security/storage/documentation/de.info.about.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(4, 'de', 5, 6, 'info.protection', 0, '1.2 Warum soll ich mein Forum sch&uuml;tzen?', '', 'lib/system/security/storage/documentation/de.info.protection.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(5, 'de', 7, 8, 'info.license', 0, '1.3 Lizenzbestimmungen', '', 'lib/system/security/storage/system/licenseFile.inc.php');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(6, 'de', 10, 23, 'attackInfo', 1, '2. Angriffsinformationen', '', '');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(7, 'de', 11, 12, 'attackInfo.bruteForce', 0, '2.1 BruteForce Methode', '', 'lib/system/security/storage/documentation/de.attackInfo.bruteForce.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(8, 'de', 13, 14, 'attackInfo.xss', 0, '2.2 Cross-Site Scripting (XSS)', '', 'lib/system/security/storage/documentation/de.attackInfo.xss.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(9, 'de', 15, 16, 'attackInfo.sqlInjection', 0, '2.3 SQL Injection', '', 'lib/system/security/storage/documentation/de.attackInfo.sqlInjection.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(10, 'de', 17, 18, 'attackInfo.parameter', 0, '2.4 Parametermanipulation', '', 'lib/system/security/storage/documentation/de.attackInfo.parameter.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(11, 'de', 19, 20, 'attackInfo.upload', 0, '2.5  Angriffe &uuml;ber Uploadfunktionen', '', 'lib/system/security/storage/documentation/de.attackInfo.upload.txt');
INSERT INTO `wcf1_security_help` (`id`, `lang`, `lft`, `rgt`, `page`, `isIndex`, `title`, `content`, `file`) VALUES(12, 'de', 21, 22, 'attackInfo.DoS', 0, '2.6  Floodangriffe und Denial of Service (DoS)', '', 'lib/system/security/storage/documentation/de.attackInfo.DoS.txt');

CREATE TABLE `wcf1_security_income` (
  `id` int(20) NOT NULL auto_increment,
  `referer` varchar(255) NOT NULL,
  `request` varchar(255) NOT NULL,
  `time` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_liveupdate_backup` (
  `id` int(20) NOT NULL auto_increment,
  `time` int(5) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `cmd` enum('deleteFile','updateFile','createFile') NOT NULL,
  `version` varchar(20) NOT NULL default 'x.x.x',
  `storageFile` varchar(255) NOT NULL,
  `rollback` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_places` (
  `placeID` bigint(20) NOT NULL auto_increment,
  `place` varchar(255) NOT NULL,
  `package` int(20) NOT NULL,
  PRIMARY KEY  (`placeID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_queue` (
  `id` int(10) NOT NULL auto_increment,
  `classPath` varchar(255) NOT NULL,
  `startExec` int(10) NOT NULL,
  `type` enum('db','ftp','system','syslog','unknown') NOT NULL default 'unknown',
  `page` int(10) NOT NULL,
  `nextPage` INT(5) NOT NULL,
  `visibleTask` tinyint(1) NOT NULL default '1',
  `error` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_releases` (
  `id` int(5) NOT NULL auto_increment,
  `version` varchar(255) NOT NULL,
  `time` int(5) NOT NULL,
  `changes` longtext NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_sessions` (
  `id` int(20) NOT NULL auto_increment,
  `sessionID` char(40) NOT NULL,
  `ipAddress` varchar(15) NOT NULL default '0.0.0.0',
  `validity` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE `wcf1_security_tokens` (
  `id` int(20) NOT NULL auto_increment,
  `token` varchar(255) NOT NULL,
  `page` varchar(255) NOT NULL,
  `validity` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE `wcf1_security_user_access_activation` (
  `id` int(20) NOT NULL auto_increment,
  `userID` int(20) NOT NULL,
  `activationCode` varchar(50) NOT NULL,
  `expiry` int(5) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `wcf1_security_flood` (
  `id` int(20) NOT NULL auto_increment,
  `ip` char(15) NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;